/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.LinkedList;
import net.kano.joscar.flap.AbstractFlapProcessor;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;

public class AsynchronousFlapProcessor
extends AbstractFlapProcessor {
    private final Object lock = new Object();
    private final LinkedList<FlapPacket> list = new LinkedList();
    private final Thread thread;
    private static final FlapPacket[] EMPTY_FLAP_ARRAY = new FlapPacket[0];
    private final WeakReference<AsynchronousFlapProcessor> processorReference = new WeakReference<AsynchronousFlapProcessor>(this);
    private static final Logger LOGGER = LoggingSystem.getLogger(AsynchronousFlapProcessor.class.getName());

    public AsynchronousFlapProcessor() {
        this.thread = new Thread((Runnable)new BackgroundPacketProcessor(this.processorReference), "FLAP processor");
        this.thread.start();
    }

    public AsynchronousFlapProcessor(Socket socket) throws IOException {
        super(socket);
        this.thread = new Thread((Runnable)new BackgroundPacketProcessor(this.processorReference), "FLAP processor");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            LOGGER.logFine(this + ": ** finalize() **");
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePacket(FlapPacket packet) {
        Object object = this.lock;
        synchronized (object) {
            this.list.add(packet);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlapPacket[] waitForPackets(long wait) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.list.isEmpty()) {
                return this.clearPackets();
            }
            this.lock.wait(wait);
            if (!this.list.isEmpty()) {
                return this.clearPackets();
            }
        }
        return EMPTY_FLAP_ARRAY;
    }

    private FlapPacket[] clearPackets() {
        assert (Thread.holdsLock(this.lock));
        FlapPacket[] packets = this.list.toArray(EMPTY_FLAP_ARRAY);
        this.list.clear();
        return packets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakdown() {
        Object object = this.lock;
        synchronized (object) {
            this.processorReference.clear();
            super.breakdown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackgroundPacketProcessor
    implements Runnable {
        private final WeakReference<AsynchronousFlapProcessor> backgroundProcessorReference;

        public BackgroundPacketProcessor(WeakReference<AsynchronousFlapProcessor> inProcessorReference) {
            this.backgroundProcessorReference = inProcessorReference;
        }

        @Override
        public void run() {
            while (this.tryProcessingPackets()) {
            }
        }

        private boolean tryProcessingPackets() {
            AsynchronousFlapProcessor processor = (AsynchronousFlapProcessor)this.backgroundProcessorReference.get();
            if (processor == null) {
                return false;
            }
            try {
                for (FlapPacket packet : processor.waitForPackets(100L)) {
                    processor.processPacketSynchronously(packet);
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }
    }
}

