/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ConfigDataSerializerHook;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MultiMapConfigReadOnly;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiMapConfig
implements IdentifiedDataSerializable {
    public static final int DEFAULT_SYNC_BACKUP_COUNT = 1;
    public static final int DEFAULT_ASYNC_BACKUP_COUNT = 0;
    public static final ValueCollectionType DEFAULT_VALUE_COLLECTION_TYPE = ValueCollectionType.SET;
    private String name;
    private String valueCollectionType = DEFAULT_VALUE_COLLECTION_TYPE.toString();
    private List<EntryListenerConfig> listenerConfigs;
    private boolean binary = true;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private boolean statisticsEnabled = true;
    private MultiMapConfigReadOnly readOnly;

    public MultiMapConfig() {
    }

    public MultiMapConfig(String name) {
        this.setName(name);
    }

    public MultiMapConfig(MultiMapConfig defConfig) {
        this.name = defConfig.getName();
        this.valueCollectionType = defConfig.valueCollectionType;
        this.binary = defConfig.binary;
        this.backupCount = defConfig.backupCount;
        this.asyncBackupCount = defConfig.asyncBackupCount;
        this.statisticsEnabled = defConfig.statisticsEnabled;
        this.listenerConfigs = new ArrayList<EntryListenerConfig>(defConfig.getEntryListenerConfigs());
    }

    public MultiMapConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new MultiMapConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public MultiMapConfig setName(String name) {
        this.name = name;
        return this;
    }

    public ValueCollectionType getValueCollectionType() {
        return ValueCollectionType.valueOf(this.valueCollectionType.toUpperCase());
    }

    public MultiMapConfig setValueCollectionType(String valueCollectionType) {
        this.valueCollectionType = valueCollectionType;
        return this;
    }

    public MultiMapConfig setValueCollectionType(ValueCollectionType valueCollectionType) {
        this.valueCollectionType = valueCollectionType.toString();
        return this;
    }

    public MultiMapConfig addEntryListenerConfig(EntryListenerConfig listenerConfig) {
        this.getEntryListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<EntryListenerConfig> getEntryListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<EntryListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public MultiMapConfig setEntryListenerConfigs(List<EntryListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public MultiMapConfig setBinary(boolean binary) {
        this.binary = binary;
        return this;
    }

    @Deprecated
    public int getSyncBackupCount() {
        return this.backupCount;
    }

    @Deprecated
    public MultiMapConfig setSyncBackupCount(int syncBackupCount) {
        this.backupCount = syncBackupCount;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public MultiMapConfig setBackupCount(int backupCount) {
        this.backupCount = Preconditions.checkBackupCount(backupCount, this.asyncBackupCount);
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public MultiMapConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(this.backupCount, asyncBackupCount);
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public MultiMapConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public String toString() {
        return "MultiMapConfig{name='" + this.name + '\'' + ", valueCollectionType='" + this.valueCollectionType + '\'' + ", listenerConfigs=" + this.listenerConfigs + ", binary=" + this.binary + ", backupCount=" + this.backupCount + ", asyncBackupCount=" + this.asyncBackupCount + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.valueCollectionType);
        if (this.listenerConfigs == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.listenerConfigs.size());
            for (ListenerConfig listenerConfig : this.listenerConfigs) {
                out.writeObject(listenerConfig);
            }
        }
        out.writeBoolean(this.binary);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
        out.writeBoolean(this.statisticsEnabled);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.valueCollectionType = in.readUTF();
        boolean hasListenerConfig = in.readBoolean();
        if (hasListenerConfig) {
            int configSize = in.readInt();
            this.listenerConfigs = new ArrayList<EntryListenerConfig>(configSize);
            for (int i = 0; i < configSize; ++i) {
                EntryListenerConfig listenerConfig = (EntryListenerConfig)in.readObject();
                this.listenerConfigs.add(listenerConfig);
            }
        }
        this.binary = in.readBoolean();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
        this.statisticsEnabled = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiMapConfig that = (MultiMapConfig)o;
        if (this.binary != that.binary) {
            return false;
        }
        if (this.backupCount != that.backupCount) {
            return false;
        }
        if (this.asyncBackupCount != that.asyncBackupCount) {
            return false;
        }
        if (this.statisticsEnabled != that.statisticsEnabled) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.valueCollectionType != null ? !this.valueCollectionType.equals(that.valueCollectionType) : that.valueCollectionType != null) {
            return false;
        }
        return this.listenerConfigs != null ? this.listenerConfigs.equals(that.listenerConfigs) : that.listenerConfigs == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.valueCollectionType != null ? this.valueCollectionType.hashCode() : 0);
        result = 31 * result + (this.listenerConfigs != null ? this.listenerConfigs.hashCode() : 0);
        result = 31 * result + (this.binary ? 1 : 0);
        result = 31 * result + this.backupCount;
        result = 31 * result + this.asyncBackupCount;
        result = 31 * result + (this.statisticsEnabled ? 1 : 0);
        return result;
    }

    public static enum ValueCollectionType {
        SET,
        LIST;

    }
}

