/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.compat.BaseV10Converter;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;

public class PrimitiveConverter
extends BaseV10Converter
implements Converter {
    private JavascriptUtil jsutil = new JavascriptUtil();

    public void setConverterManager(ConverterManager config) {
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        try {
            if (paramType == Boolean.TYPE || paramType == Boolean.class) {
                return Boolean.valueOf(value.trim());
            }
            if (paramType == Byte.TYPE || paramType == Byte.class) {
                if (value.length() == 0) {
                    byte b = 0;
                    return new Byte(b);
                }
                return new Byte(value.trim());
            }
            if (paramType == Short.TYPE || paramType == Short.class) {
                if (value.length() == 0) {
                    short s = 0;
                    return new Short(s);
                }
                return new Short(value.trim());
            }
            if (paramType == Character.TYPE || paramType == Character.class) {
                String decode = LocalUtil.decode(value);
                if (decode.length() == 1) {
                    return new Character(decode.charAt(0));
                }
                throw new ConversionException(Messages.getString("PrimitiveConverter.StringTooLong", value));
            }
            if (paramType == Integer.TYPE || paramType == Integer.class) {
                if (value.length() == 0) {
                    return new Integer(0);
                }
                return new Integer(value.trim());
            }
            if (paramType == Long.TYPE || paramType == Long.class) {
                if (value.length() == 0) {
                    return new Long(0L);
                }
                return new Long(value.trim());
            }
            if (paramType == Float.TYPE || paramType == Float.class) {
                if (value.length() == 0) {
                    return new Float(0.0f);
                }
                return new Float(LocalUtil.decode(value.trim()));
            }
            if (paramType == Double.TYPE || paramType == Double.class) {
                if (value.length() == 0) {
                    return new Double(0.0);
                }
                return new Double(LocalUtil.decode(value.trim()));
            }
            throw new ConversionException(Messages.getString("PrimitiveConverter.TypeNotPrimitive", paramType.getName()));
        }
        catch (NumberFormatException ex) {
            throw new ConversionException(Messages.getString("PrimitiveConverter.FormatError", value, paramType.getName()), ex);
        }
    }

    public String convertOutbound(Object object, String varname, OutboundContext outctx) {
        Class<?> paramType = object.getClass();
        if (object.equals(Boolean.TRUE)) {
            return "var " + varname + "=true;";
        }
        if (object.equals(Boolean.FALSE)) {
            return "var " + varname + "=false;";
        }
        if (paramType == Character.class) {
            return "var " + varname + "=\"" + this.jsutil.escapeJavaScript(object.toString()) + "\";";
        }
        return "var " + varname + '=' + object.toString() + ';';
    }
}

