/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.util.logging.Logger;
import net.kano.joscar.rvproto.rvproxy.RvProxyAckCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyErrorCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyReadyCmd;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FailureEventException;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractOutgoingConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ProxyConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ProxyConnector;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StreamProxyConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.AolProxyTimedOutEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.UnknownAolProxyErrorEvent;

public abstract class AbstractProxyConnectionController
extends AbstractOutgoingConnectionController {
    private static final Logger LOGGER = Logger.getLogger(AbstractProxyConnectionController.class.getName());

    public ConnectionType getTimeoutType() {
        return ConnectionType.PROXY;
    }

    protected void initializeConnectionInThread() throws IOException, FailureEventException {
        this.initializeProxy();
        while (true) {
            RvProxyCmd cmd;
            if ((cmd = this.getProxyConnection().readPacket()) instanceof RvProxyAckCmd) {
                RvProxyAckCmd ackCmd = (RvProxyAckCmd)cmd;
                this.stopConnectionTimer();
                this.handleAck(ackCmd);
                continue;
            }
            if (cmd instanceof RvProxyErrorCmd) {
                RvProxyErrorCmd proxyErrorCmd = (RvProxyErrorCmd)cmd;
                int code = proxyErrorCmd.getErrorCode();
                if (code == 26) {
                    this.fireFailed(new AolProxyTimedOutEvent());
                    break;
                }
                this.fireFailed(new UnknownAolProxyErrorEvent(code));
                break;
            }
            if (cmd instanceof RvProxyReadyCmd) {
                this.fireConnected();
                break;
            }
            LOGGER.warning("Got unknown RV proxy packet: " + cmd);
        }
    }

    public RvProxyCmd readPacket() throws IOException {
        return this.getProxyConnection().readPacket();
    }

    protected final boolean shouldStartTimerAutomatically() {
        return true;
    }

    protected abstract void handleAck(RvProxyAckCmd var1) throws IOException;

    protected abstract void initializeProxy() throws IOException;

    protected void sendProxyPacket(RvProxyCmd initCmd) throws IOException {
        this.getProxyConnection().sendProxyPacket(initCmd);
    }

    public ProxyConnector getConnector() {
        return (ProxyConnector)super.getConnector();
    }

    protected ProxyConnection getProxyConnection() {
        return this.getConnector().getProxyConnection();
    }

    public abstract class DefaultProxyConnector
    extends AbstractOutgoingConnectionController.DefaultOutgoingConnector
    implements ProxyConnector {
        private ProxyConnection proxyConnection;

        public DefaultProxyConnector() {
            this.proxyConnection = new StreamProxyConnection(AbstractProxyConnectionController.this);
        }

        public int getConnectionPort() {
            return 5190;
        }

        public ProxyConnection getProxyConnection() {
            return this.proxyConnection;
        }
    }
}

