/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.TypeHintContext;
import uk.ltd.getahead.dwr.compat.BaseV10Converter;
import uk.ltd.getahead.dwr.util.LocalUtil;

public class CollectionConverter
extends BaseV10Converter
implements Converter {
    private ConverterManager config = null;

    public void setConverterManager(ConverterManager newConfig) {
        this.config = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("[")) {
            throw new IllegalArgumentException(Messages.getString("CollectionConverter.MissingOpener", "["));
        }
        if (!value.endsWith("]")) {
            throw new IllegalArgumentException(Messages.getString("CollectionConverter.MissingCloser", "]"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            TypeHintContext icc = inctx.getCurrentTypeHintContext();
            TypeHintContext subthc = icc.createChildContext(0);
            Class subtype = this.config.getExtraTypeInfo(subthc);
            Collection<Object> col = null;
            if (Iterator.class.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if (!paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers())) {
                col = (Collection)paramType.newInstance();
            } else if (SortedSet.class.isAssignableFrom(paramType)) {
                col = new TreeSet();
            } else if (Set.class.isAssignableFrom(paramType)) {
                col = new HashSet();
            } else if (List.class.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if (Collection.class.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else {
                throw new ConversionException(Messages.getString("CollectionConverter.ConvertError") + paramType.getName());
            }
            inctx.addConverted(iv, paramType, col);
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                String[] split = LocalUtil.splitInbound(token);
                String splitType = split[0];
                String splitValue = split[1];
                InboundVariable nested = new InboundVariable(iv.getLookup(), null, splitType, splitValue);
                Object output = this.config.convertInbound(subtype, nested, inctx, subthc);
                col.add(output);
            }
            if (Iterator.class.isAssignableFrom(paramType)) {
                return col.iterator();
            }
            return col;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        Iterator it = null;
        if (data instanceof Collection) {
            Collection col = (Collection)data;
            it = col.iterator();
        } else if (data instanceof Iterator) {
            it = (Iterator)data;
        } else {
            throw new ConversionException(Messages.getString("CollectionConverter.ConvertFailed", data.getClass().getName()));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("var " + varname + "=[];");
        int i = 0;
        while (it.hasNext()) {
            Object element = it.next();
            OutboundVariable nested = this.config.convertOutbound(element, outctx);
            buffer.append(nested.getInitCode());
            buffer.append(varname);
            buffer.append('[');
            buffer.append(i);
            buffer.append("]=");
            buffer.append(nested.getAssignCode());
            buffer.append(';');
            ++i;
        }
        return buffer.toString();
    }
}

