/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.IOSelectorOutOfMemoryHandler;
import com.hazelcast.nio.tcp.MigratableHandler;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class AbstractIOSelector
extends Thread
implements IOSelector {
    private static final int SELECT_WAIT_TIME_MILLIS = 5000;
    private static final int SELECT_FAILURE_PAUSE_MILLIS = 1000;
    private final ILogger logger;
    private final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    private final int waitTime;
    private final Selector selector;
    private final IOSelectorOutOfMemoryHandler oomeHandler;
    private boolean running = true;

    public AbstractIOSelector(ThreadGroup threadGroup, String threadName, ILogger logger, IOSelectorOutOfMemoryHandler oomeHandler) {
        super(threadGroup, threadName);
        this.logger = logger;
        this.oomeHandler = oomeHandler;
        this.waitTime = 5000;
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new HazelcastException("Failed to open a Selector", e);
        }
    }

    @Override
    public final void shutdown() {
        this.selectorQueue.clear();
        try {
            this.addTask(new Runnable(){

                @Override
                public void run() {
                    AbstractIOSelector.this.running = false;
                }
            });
            this.interrupt();
        }
        catch (Throwable t) {
            Logger.getLogger(AbstractIOSelector.class).finest("Exception while waiting for shutdown", t);
        }
    }

    @Override
    public final void addTask(Runnable task) {
        this.selectorQueue.add(task);
    }

    @Override
    public final void addTaskAndWakeup(Runnable task) {
        this.selectorQueue.add(task);
        this.selector.wakeup();
    }

    private void processSelectionQueue() {
        while (this.running) {
            Runnable task = this.selectorQueue.poll();
            if (task == null) {
                return;
            }
            this.executeTask(task);
        }
    }

    private void executeTask(Runnable task) {
        IOSelector target = this.getTargetIOSelector(task);
        if (target == this) {
            task.run();
        } else {
            target.addTask(task);
        }
    }

    private IOSelector getTargetIOSelector(Runnable task) {
        if (task instanceof MigratableHandler) {
            return ((MigratableHandler)((Object)task)).getOwner();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            while (this.running) {
                block25: {
                    this.processSelectionQueue();
                    if (!this.running || this.isInterrupted()) {
                        if (this.logger.isFinestEnabled()) {
                            this.logger.finest(this.getName() + " is interrupted!");
                        }
                        this.running = false;
                        return;
                    }
                    try {
                        int selectedKeyCount = this.selector.select(this.waitTime);
                        if (selectedKeyCount == 0) {
                        }
                        break block25;
                    }
                    catch (Throwable e) {
                        this.handleSelectFailure(e);
                    }
                    continue;
                }
                this.handleSelectionKeys();
            }
        }
        catch (OutOfMemoryError e) {
            this.oomeHandler.handle(e);
        }
        catch (Throwable e) {
            this.logger.warning("Unhandled exception in " + this.getName(), e);
        }
        finally {
            try {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Closing selector " + this.getName());
                }
                this.selector.close();
            }
            catch (Exception e) {
                Logger.getLogger(AbstractIOSelector.class).finest("Exception while closing selector", e);
            }
        }
    }

    protected abstract void handleSelectionKey(SelectionKey var1);

    private void handleSelectionKeys() {
        Set<SelectionKey> setSelectedKeys = this.selector.selectedKeys();
        Iterator<SelectionKey> it = setSelectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey sk = it.next();
            it.remove();
            try {
                this.handleSelectionKey(sk);
            }
            catch (Throwable e) {
                this.handleSelectionKeyFailure(e);
            }
        }
    }

    @Override
    public void handleSelectionKeyFailure(Throwable e) {
        this.logger.warning("Selector exception at  " + this.getName() + ", cause= " + e.toString(), e);
        if (e instanceof OutOfMemoryError) {
            this.oomeHandler.handle((OutOfMemoryError)e);
        }
    }

    @Override
    public final Selector getSelector() {
        return this.selector;
    }

    private void handleSelectFailure(Throwable e) {
        this.logger.warning(e.toString(), e);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            Thread.currentThread().interrupt();
        }
    }
}

