/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video;

import org.jitsi.impl.neomedia.codec.FFmpeg;

public class ByteBuffer {
    private int capacity;
    private int length;
    private long ptr;

    public ByteBuffer(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity");
        }
        this.ptr = FFmpeg.av_malloc(capacity);
        if (this.ptr == 0L) {
            throw new OutOfMemoryError("av_malloc(" + capacity + ")");
        }
        this.capacity = capacity;
        this.length = 0;
    }

    public ByteBuffer(long ptr) {
        this.ptr = ptr;
        this.capacity = 0;
        this.length = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void free() {
        if (this.capacity != 0 && this.ptr != 0L) {
            FFmpeg.av_free(this.ptr);
            this.capacity = 0;
            this.ptr = 0L;
        }
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public int getLength() {
        return this.length;
    }

    public synchronized long getPtr() {
        return this.ptr;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length");
        }
        this.length = length;
    }
}

