/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.Enumeration;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.TimeoutEvent;
import net.sf.fmj.media.rtp.PassiveSSRCInfo;
import net.sf.fmj.media.rtp.RTPSourceInfo;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.RTPMediaThread;

public class SSRCCacheCleaner
implements Runnable {
    private SSRCCache cache;
    private RTPMediaThread thread;
    private static final int DEATHTIME = 1800000;
    private static final int TIMEOUT_MULTIPLIER = 5;
    boolean timeToClean = false;
    private boolean killed = false;
    private StreamSynch streamSynch;
    private long lastCleaned = -1L;

    public SSRCCacheCleaner(SSRCCache cache, StreamSynch streamSynch) {
        this.cache = cache;
        this.streamSynch = streamSynch;
        this.thread = new RTPMediaThread(this, "SSRC Cache Cleaner");
        this.thread.useControlPriority();
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void cleannow() {
        long time;
        this.lastCleaned = time = System.currentTimeMillis();
        if (this.cache.ourssrc == null) {
            return;
        }
        double reportInterval = this.cache.calcReportInterval(this.cache.ourssrc.sender, true);
        Enumeration<SSRCInfo> elements = this.cache.cache.elements();
        while (elements.hasMoreElements()) {
            SSRCInfo info = elements.nextElement();
            if (info.ours) continue;
            if (info.byeReceived) {
                if (time - info.byeTime < 1000L) {
                    try {
                        Thread.sleep(1000L - time + info.byeTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    time = System.currentTimeMillis();
                }
                info.byeTime = 0L;
                info.byeReceived = false;
                this.cache.remove(info.ssrc);
                this.streamSynch.remove(info.ssrc);
                boolean byepart = false;
                RTPSourceInfo sourceInfo = info.sourceInfo;
                if (sourceInfo != null && sourceInfo.getStreamCount() == 0) {
                    byepart = true;
                }
                ByeEvent evtbye = null;
                if (info instanceof RecvSSRCInfo) {
                    evtbye = new ByeEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), info.byereason, byepart);
                }
                if (info instanceof PassiveSSRCInfo) {
                    evtbye = new ByeEvent(this.cache.sm, info.sourceInfo, null, info.byereason, byepart);
                }
                this.cache.eventhandler.postEvent(evtbye);
                continue;
            }
            if (!((double)info.lastHeardFrom + reportInterval <= (double)time)) continue;
            InactiveReceiveStreamEvent event = null;
            if (!info.inactivesent) {
                boolean laststream = false;
                RTPSourceInfo si = info.sourceInfo;
                if (si != null && si.getStreamCount() == 1) {
                    laststream = true;
                }
                if (info instanceof ReceiveStream) {
                    event = new InactiveReceiveStreamEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), laststream);
                } else if ((double)info.lastHeardFrom + reportInterval * 5.0 <= (double)time) {
                    event = new InactiveReceiveStreamEvent(this.cache.sm, info.sourceInfo, null, laststream);
                }
                if (event == null) continue;
                this.cache.eventhandler.postEvent(event);
                info.quiet = true;
                info.inactivesent = true;
                info.setAlive(false);
                continue;
            }
            if (info.lastHeardFrom + 5000L > time) continue;
            TimeoutEvent evt = null;
            this.cache.remove(info.ssrc);
            boolean byepart = false;
            RTPSourceInfo sourceInfo = info.sourceInfo;
            if (sourceInfo != null && sourceInfo.getStreamCount() == 0) {
                byepart = true;
            }
            evt = info instanceof ReceiveStream ? new TimeoutEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), byepart) : new TimeoutEvent(this.cache.sm, info.sourceInfo, null, byepart);
            this.cache.eventhandler.postEvent(evt);
        }
    }

    public synchronized void run() {
        try {
            while (true) {
                if (!this.timeToClean && !this.killed) {
                    this.wait(5000L);
                }
                if (this.killed) {
                    return;
                }
                if (!this.timeToClean && this.lastCleaned + 5000L <= System.currentTimeMillis()) {
                    this.timeToClean = true;
                }
                if (this.timeToClean) {
                    this.cleannow();
                }
                this.timeToClean = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public synchronized void setClean() {
        this.timeToClean = true;
        this.notifyAll();
    }

    public synchronized void stop() {
        this.killed = true;
        this.notifyAll();
    }
}

