/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.media.format.GIFFormat;
import net.sf.fmj.media.format.PNGFormat;
import net.sf.fmj.utility.LoggerSingleton;

public class MultipartMixedReplaceParser
extends AbstractDemultiplexer {
    public static final String TIMESTAMP_KEY = "X-FMJ-Timestamp";
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("multipart.x_mixed_replace")};
    private static final String[] supportedFrameContentTypes = new String[]{"image/jpeg", "image/gif", "image/png"};
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;

    private static String toPrintable(String line) {
        return MultipartMixedReplaceParser.toPrintable(line, 32);
    }

    private static String toPrintable(String line, int max) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < line.length() && i < max; ++i) {
            char c = line.charAt(i);
            if (c >= ' ' && c <= '~') {
                b.append(c);
                continue;
            }
            b.append('.');
        }
        return b.toString();
    }

    private static final boolean isSupportedFrameContentType(String contentType) {
        for (String supported : supportedFrameContentTypes) {
            if (!supported.equals(contentType.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.tracks != null) {
            for (int i = 0; i < this.tracks.length; ++i) {
                if (this.tracks[i] == null) continue;
                this.tracks[i].deallocate();
                this.tracks[i] = null;
            }
            this.tracks = null;
        }
        super.close();
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return false;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public void open() throws ResourceUnavailableException {
        try {
            this.source.start();
            PullSourceStream[] streams = this.source.getStreams();
            this.tracks = new PullSourceStreamTrack[streams.length];
            for (int i = 0; i < streams.length; ++i) {
                this.tracks[i] = new VideoTrack(streams[i]);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new ResourceUnavailableException("" + e);
        }
        super.open();
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        String protocol = source.getLocator().getProtocol();
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    public void start() throws IOException {
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final PullSourceStream stream;
        private final VideoFormat format;
        private byte[] pushbackBuffer;
        private int pushbackBufferLen;
        private int pushbackBufferOffset;
        private static final int MAX_LINE_LENGTH = 255;
        private final int MAX_IMAGE_SIZE = 1000000;
        private String boundary;
        private int framesRead;
        private String frameContentType;

        public VideoTrack(PullSourceStream stream) throws ResourceUnavailableException {
            BufferedImage image;
            this.MAX_IMAGE_SIZE = 1000000;
            this.stream = stream;
            Buffer buffer = new Buffer();
            this.readFrame(buffer);
            if (buffer.isDiscard() || buffer.isEOM()) {
                throw new ResourceUnavailableException("Unable to read first frame");
            }
            try {
                image = ImageIO.read(new ByteArrayInputStream((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength()));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new ResourceUnavailableException("Error reading image: " + e);
            }
            if (image == null) {
                logger.log(Level.WARNING, "Failed to read image (ImageIO.read returned null).");
                throw new ResourceUnavailableException();
            }
            if (this.frameContentType.equals("image/jpeg")) {
                this.format = new JPEGFormat(new Dimension(((Image)image).getWidth(null), ((Image)image).getHeight(null)), -1, Format.byteArray, -1.0f, -1, -1);
            } else if (this.frameContentType.equals("image/gif")) {
                this.format = new GIFFormat(new Dimension(((Image)image).getWidth(null), ((Image)image).getHeight(null)), -1, Format.byteArray, -1.0f);
            } else if (this.frameContentType.equals("image/png")) {
                this.format = new PNGFormat(new Dimension(((Image)image).getWidth(null), ((Image)image).getHeight(null)), -1, Format.byteArray, -1.0f);
            } else {
                throw new ResourceUnavailableException("Unsupported frame content type: " + this.frameContentType);
            }
        }

        public void deallocate() {
        }

        private int eatUntil(String boundary) throws IOException {
            int totalEaten = 0;
            byte[] boundaryBytes = boundary.getBytes();
            byte[] matchBuffer = new byte[boundaryBytes.length];
            int matchOffset = 0;
            while (true) {
                int lenRead;
                if ((lenRead = this.read(matchBuffer, matchOffset, 1)) < 0) {
                    return -1 + -1 * totalEaten;
                }
                ++totalEaten;
                if (matchBuffer[matchOffset] == boundaryBytes[matchOffset]) {
                    if (matchOffset == boundaryBytes.length - 1) break;
                    ++matchOffset;
                    continue;
                }
                if (matchOffset <= 0) continue;
                matchOffset = 0;
            }
            this.pushback(matchBuffer, matchOffset + 1);
            return totalEaten -= matchOffset + 1;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        private boolean parseProperty(String line, Properties properties) {
            int index = line.indexOf(58);
            if (index < 0) {
                return false;
            }
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim();
            properties.setProperty(key.toUpperCase(), value);
            return true;
        }

        private void pushback(byte[] bytes, int len) {
            if (this.pushbackBufferLen == 0) {
                this.pushbackBuffer = bytes;
                this.pushbackBufferLen = len;
                this.pushbackBufferOffset = 0;
            } else {
                byte[] newPushbackBuffer = new byte[this.pushbackBufferLen + len];
                System.arraycopy(this.pushbackBuffer, 0, newPushbackBuffer, 0, this.pushbackBufferLen);
                System.arraycopy(bytes, 0, newPushbackBuffer, this.pushbackBufferLen, len);
                this.pushbackBuffer = newPushbackBuffer;
                this.pushbackBufferLen += len;
                this.pushbackBufferOffset = 0;
            }
        }

        private int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.pushbackBufferLen > 0) {
                int lenToCopy = length < this.pushbackBufferLen ? length : this.pushbackBufferLen;
                System.arraycopy(this.pushbackBuffer, this.pushbackBufferOffset, buffer, offset, lenToCopy);
                this.pushbackBufferLen -= lenToCopy;
                this.pushbackBufferOffset += lenToCopy;
                return lenToCopy;
            }
            return this.stream.read(buffer, offset, length);
        }

        public void readFrame(Buffer buffer) {
            try {
                byte[] data;
                Properties properties;
                block23: {
                    String line;
                    do {
                        if ((line = this.readLine(255)) != null) continue;
                        buffer.setEOM(true);
                        buffer.setLength(0);
                        return;
                    } while (line.trim().equals(""));
                    if (this.boundary == null) {
                        this.boundary = line.trim();
                    } else if (!line.trim().equals(this.boundary)) {
                        logger.warning("Expected boundary (frame " + this.framesRead + "): " + MultipartMixedReplaceParser.toPrintable(line));
                        int eatResult = this.eatUntil(this.boundary);
                        logger.info("Ignored bytes (eom after=" + (eatResult < 0) + "): " + (eatResult < 0 ? -1 * eatResult - 1 : eatResult));
                        if (eatResult < 0) {
                            buffer.setEOM(true);
                            buffer.setLength(0);
                            return;
                        }
                        line = this.readLine(255);
                        if (!line.trim().equals(this.boundary)) {
                            throw new RuntimeException("No boundary found after eatUntil(boundary)");
                        }
                    }
                    properties = new Properties();
                    do {
                        if ((line = this.readLine(255)) == null) {
                            buffer.setEOM(true);
                            buffer.setLength(0);
                            return;
                        }
                        if (line.trim().equals("")) break block23;
                    } while (this.parseProperty(line, properties));
                    throw new IOException("Expected property: " + MultipartMixedReplaceParser.toPrintable(line));
                }
                String contentType = properties.getProperty("Content-Type".toUpperCase());
                if (contentType == null) {
                    logger.warning("Header properties: " + properties);
                    throw new IOException("Expected Content-Type in header");
                }
                if (!MultipartMixedReplaceParser.isSupportedFrameContentType(contentType)) {
                    throw new IOException("Unsupported Content-Type: " + contentType);
                }
                if (this.frameContentType == null) {
                    this.frameContentType = contentType;
                } else if (!contentType.equals(this.frameContentType)) {
                    throw new IOException("Content type changed during stream from " + this.frameContentType + " to " + contentType);
                }
                String contentLenStr = properties.getProperty("Content-Length".toUpperCase());
                if (contentLenStr != null) {
                    int contentLen;
                    try {
                        contentLen = Integer.parseInt(contentLenStr);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Invalid content length: " + contentLenStr);
                    }
                    data = this.readFully(contentLen);
                } else {
                    data = this.readUntil(this.boundary);
                }
                String timestampStr = properties.getProperty(MultipartMixedReplaceParser.TIMESTAMP_KEY.toUpperCase());
                if (timestampStr != null) {
                    try {
                        long timestamp = Long.parseLong(timestampStr);
                        buffer.setTimeStamp(timestamp);
                    }
                    catch (NumberFormatException e) {
                        logger.log(Level.WARNING, "" + e, e);
                    }
                }
                if (data == null) {
                    buffer.setEOM(true);
                    buffer.setLength(0);
                    return;
                }
                buffer.setData(data);
                buffer.setOffset(0);
                buffer.setLength(data.length);
                ++this.framesRead;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private byte[] readFully(int bytes) throws IOException {
            byte[] buffer = new byte[bytes];
            int offset = 0;
            int length = bytes;
            int lenRead;
            while ((lenRead = this.read(buffer, offset, length)) >= 0) {
                if (lenRead == length) {
                    return buffer;
                }
                length -= lenRead;
                offset += lenRead;
            }
            return null;
        }

        private String readLine(int max) throws IOException {
            byte[] buffer = new byte[max];
            int offset = 0;
            boolean length = true;
            while (true) {
                if (offset >= max) {
                    throw new MaxLengthExceededException("No newline found in " + max + " bytes");
                }
                int lenRead = this.read(buffer, offset, 1);
                if (lenRead < 0) {
                    return null;
                }
                if (buffer[offset] == 10) {
                    if (offset > 0 && buffer[offset - 1] == 13) {
                        --offset;
                    }
                    return new String(buffer, 0, offset);
                }
                ++offset;
            }
        }

        private byte[] readUntil(String boundary) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] boundaryBytes = boundary.getBytes();
            byte[] matchBuffer = new byte[boundaryBytes.length];
            int matchOffset = 0;
            while (true) {
                if (os.size() >= 1000000) {
                    throw new IOException("No boundary found in 1000000 bytes.");
                }
                int lenRead = this.read(matchBuffer, matchOffset, 1);
                if (lenRead < 0) {
                    return null;
                }
                if (matchBuffer[matchOffset] == boundaryBytes[matchOffset]) {
                    if (matchOffset == boundaryBytes.length - 1) break;
                    ++matchOffset;
                    continue;
                }
                if (matchOffset > 0) {
                    os.write(matchBuffer, 0, matchOffset + 1);
                    matchOffset = 0;
                    continue;
                }
                os.write(matchBuffer, 0, 1);
            }
            this.pushback(matchBuffer, matchOffset + 1);
            byte[] result = os.toByteArray();
            return result;
        }

        private class MaxLengthExceededException
        extends IOException {
            public MaxLengthExceededException(String s) {
                super(s);
            }
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }
}

