/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectCircleJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectImageJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectLineJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectPathJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectPolyLineJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectPolygonJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectRectJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectTextJabberImpl;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.packet.PacketExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WhiteboardObjectPacketExtension
implements PacketExtension {
    private static final Logger logger = Logger.getLogger(WhiteboardObjectPacketExtension.class);
    public static final String ELEMENT_NAME = "xObject";
    public static final String NAMESPACE = "http://jabber.org/protocol/swb";
    public static final String ACTION_DELETE = "DELETE";
    public static final String ACTION_DRAW = "DRAW";
    public static final String ACTION_MOVE = "MOVE";
    private WhiteboardObjectJabberImpl whiteboardObject;
    private String action;
    private String whiteboardObjectID;

    public WhiteboardObjectPacketExtension() {
        this.action = ACTION_DRAW;
    }

    public WhiteboardObjectPacketExtension(String id, String action) {
        this.whiteboardObjectID = id;
        this.action = action;
    }

    public WhiteboardObjectPacketExtension(WhiteboardObjectJabberImpl whiteboardObject, String action) {
        this.whiteboardObject = whiteboardObject;
        this.action = action;
    }

    public WhiteboardObjectPacketExtension(String xml) {
        block25: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                this.action = ACTION_DRAW;
                if (elementName.equals("rect")) {
                    this.whiteboardObject = new WhiteboardObjectRectJabberImpl(xml);
                } else if (elementName.equals("circle")) {
                    this.whiteboardObject = new WhiteboardObjectCircleJabberImpl(xml);
                } else if (elementName.equals("path")) {
                    this.whiteboardObject = new WhiteboardObjectPathJabberImpl(xml);
                } else if (elementName.equals("polyline")) {
                    this.whiteboardObject = new WhiteboardObjectPolyLineJabberImpl(xml);
                } else if (elementName.equals("polygon")) {
                    this.whiteboardObject = new WhiteboardObjectPolygonJabberImpl(xml);
                } else if (elementName.equals("line")) {
                    this.whiteboardObject = new WhiteboardObjectLineJabberImpl(xml);
                } else if (elementName.equals("text")) {
                    this.whiteboardObject = new WhiteboardObjectTextJabberImpl(xml);
                } else if (elementName.equals("image")) {
                    this.whiteboardObject = new WhiteboardObjectImageJabberImpl(xml);
                } else if (elementName.equals("delete")) {
                    this.setWhiteboardObjectID(e.getAttribute("id"));
                    this.action = ACTION_DELETE;
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"elementName unknow\n");
                }
            }
            catch (ParserConfigurationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml), (Throwable)ex);
                }
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block25;
                logger.debug((Object)("Problem WhiteboardObject : " + xml), (Throwable)ex);
            }
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String toXML() {
        String s = "";
        if (this.getAction().equals(ACTION_DELETE)) {
            s = "<delete id=\"#i\"/>";
            s = s.replaceAll("#i", this.getWhiteboardObjectID());
        } else {
            s = this.getWhiteboardObject().toXML();
        }
        return "<xObject xmlns=\"http://jabber.org/protocol/swb\">" + s + "</" + ELEMENT_NAME + ">";
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public WhiteboardObjectJabberImpl getWhiteboardObject() {
        return this.whiteboardObject;
    }

    public String getWhiteboardObjectID() {
        return this.whiteboardObjectID;
    }

    public void setWhiteboardObjectID(String objectID) {
        this.whiteboardObjectID = objectID;
    }
}

