/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.verb;

import com.rayo.core.validation.ValidRecognizer;
import com.rayo.core.verb.BaseVerb;
import com.rayo.core.verb.Choices;
import com.rayo.core.verb.InputMode;
import com.rayo.core.verb.Ssml;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.AssertTrue;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.Duration;

public class Ask
extends BaseVerb {
    private String voice;
    @Valid
    private Ssml prompt;
    private boolean bargein = true;
    @Valid
    @NotEmpty(message="You need to provide at least a valid choice element or CPA data.")
    private List<Choices> choices;
    private InputMode mode = InputMode.ANY;
    @ValidRecognizer
    private String recognizer;
    private float minConfidence = 0.3f;
    private Character terminator;
    private Duration timeout = new Duration(30000L);

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String voice) {
        this.voice = voice;
    }

    public Ssml getPrompt() {
        return this.prompt;
    }

    public void setPrompt(Ssml promptItems) {
        this.prompt = promptItems;
    }

    public boolean isBargein() {
        return this.bargein;
    }

    public void setBargein(boolean bargein) {
        this.bargein = bargein;
    }

    public List<Choices> getChoices() {
        return this.choices;
    }

    public void setChoices(List<Choices> choicesList) {
        this.choices = choicesList;
    }

    public InputMode getMode() {
        return this.mode;
    }

    public void setMode(InputMode mode) {
        this.mode = mode;
    }

    public String getRecognizer() {
        return this.recognizer;
    }

    public void setRecognizer(String recognizer) {
        this.recognizer = recognizer;
    }

    public float getMinConfidence() {
        return this.minConfidence;
    }

    public void setMinConfidence(float minConfidence) {
        this.minConfidence = minConfidence;
    }

    public Character getTerminator() {
        return this.terminator;
    }

    public void setTerminator(Character terminator) {
        this.terminator = terminator;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @AssertTrue(message="Confidence must be a value between 0 and 1.")
    public boolean isMinConfidenceWithinRange() {
        return this.minConfidence >= 0.0f && this.minConfidence <= 1.0f;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("callId", (Object)this.getCallId()).append("verbId", (Object)this.getVerbId()).append("prompt", (Object)this.prompt).append("bargein", this.bargein).append("choices", this.choices).append("mode", (Object)this.mode).append("recognizer", (Object)this.recognizer).append("minConfidence", this.minConfidence).append("terminator", (Object)this.terminator).append("timeout", (Object)this.timeout).append("voice", (Object)this.voice).toString();
    }
}

