/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheEventDataImpl;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheMXBeanImpl;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.CacheStatisticsMXBeanImpl;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.MXBeanUtil;
import com.hazelcast.cache.impl.operation.CacheCreateConfigOperation;
import com.hazelcast.cache.impl.operation.CacheDestroyOperation;
import com.hazelcast.cache.impl.operation.CacheReplicationOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CacheService
implements ManagedService,
RemoteService,
MigrationAwareService,
EventPublishingService<Object, CacheEventListener> {
    public static final String SERVICE_NAME = "hz:impl:cacheService";
    private final ConcurrentMap<String, CacheConfig> configs = new ConcurrentHashMap<String, CacheConfig>();
    private final ConcurrentMap<String, CacheStatisticsImpl> statistics = new ConcurrentHashMap<String, CacheStatisticsImpl>();
    private NodeEngine nodeEngine;
    private CachePartitionSegment[] segments;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.segments = new CachePartitionSegment[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            this.segments[i] = new CachePartitionSegment(nodeEngine, this, i);
        }
    }

    @Override
    public void reset() {
        CachePartitionSegment[] partitionSegments;
        ConcurrentMap<String, CacheConfig> cacheConfigs = this.configs;
        for (String objectName : cacheConfigs.keySet()) {
            this.destroyCache(objectName, true, null);
        }
        for (CachePartitionSegment partitionSegment : partitionSegments = this.segments) {
            if (partitionSegment == null) continue;
            partitionSegment.clear();
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        if (!terminate) {
            this.reset();
        }
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        return new CacheDistributedObject(objectName, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        CachePartitionSegment segment = this.segments[event.getPartitionId()];
        CacheReplicationOperation op = new CacheReplicationOperation(segment, event.getReplicaIndex());
        return op.isEmpty() ? null : op;
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.segments[partitionId].clear();
    }

    public ICacheRecordStore getOrCreateCache(String name, int partitionId) {
        return this.segments[partitionId].getOrCreateCache(name);
    }

    public ICacheRecordStore getCache(String name, int partitionId) {
        return this.segments[partitionId].getCache(name);
    }

    public void destroyCache(String objectName, boolean isLocal, String callerUuid) {
        for (CachePartitionSegment segment : this.segments) {
            segment.deleteCache(objectName);
        }
        if (!isLocal) {
            this.deregisterAllListener(objectName);
        }
        this.enableStatistics(objectName, false);
        this.enableManagement(objectName, false);
        this.deleteCacheConfig(objectName);
        this.deleteCacheStat(objectName);
        if (!isLocal) {
            this.destroyCacheOnAllMembers(objectName, callerUuid);
        }
    }

    protected void destroyCacheOnAllMembers(String objectName, String callerUuid) {
        OperationService operationService = this.nodeEngine.getOperationService();
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            if (member.localMember() || member.getUuid().equals(callerUuid)) continue;
            CacheDestroyOperation op = new CacheDestroyOperation(objectName, true);
            operationService.invokeOnTarget(SERVICE_NAME, op, member.getAddress());
        }
    }

    public boolean createCacheConfigIfAbsent(CacheConfig config, boolean isLocal) {
        boolean created;
        CacheConfig localConfig = this.configs.putIfAbsent(config.getNameWithPrefix(), config);
        boolean bl = created = localConfig == null;
        if (created) {
            if (config.isStatisticsEnabled()) {
                this.enableStatistics(config.getNameWithPrefix(), true);
            }
            if (config.isManagementEnabled()) {
                this.enableManagement(config.getNameWithPrefix(), true);
            }
            if (!isLocal) {
                this.createConfigOnAllMembers(config);
            }
        }
        return created;
    }

    protected <K, V> void createConfigOnAllMembers(CacheConfig<K, V> cacheConfig) {
        OperationService operationService = this.nodeEngine.getOperationService();
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            CacheCreateConfigOperation op = new CacheCreateConfigOperation(cacheConfig, true);
            operationService.invokeOnTarget(SERVICE_NAME, op, member.getAddress());
        }
    }

    public void deleteCacheConfig(String name) {
        this.configs.remove(name);
    }

    public CacheStatisticsImpl createCacheStatIfAbsent(String name) {
        if (!this.statistics.containsKey(name)) {
            this.statistics.putIfAbsent(name, new CacheStatisticsImpl());
        }
        return (CacheStatisticsImpl)this.statistics.get(name);
    }

    public void deleteCacheStat(String name) {
        this.statistics.remove(name);
    }

    public void enableStatistics(String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig = (CacheConfig)this.configs.get(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setStatisticsEnabled(enabled);
            if (enabled) {
                CacheStatisticsImpl cacheStatistics = this.createCacheStatIfAbsent(cacheNameWithPrefix);
                CacheStatisticsMXBeanImpl mxBean = new CacheStatisticsMXBeanImpl(cacheStatistics);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), true);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), true);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    public void enableManagement(String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig = (CacheConfig)this.configs.get(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setManagementEnabled(enabled);
            if (enabled) {
                CacheMXBeanImpl mxBean = new CacheMXBeanImpl(cacheConfig);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), false);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), false);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    public CacheConfig getCacheConfig(String name) {
        return (CacheConfig)this.configs.get(name);
    }

    public Collection<CacheConfig> getCacheConfigs() {
        return this.configs.values();
    }

    public Object toObject(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Data) {
            return this.nodeEngine.toObject(data);
        }
        return data;
    }

    public Data toData(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Data) {
            return (Data)object;
        }
        return this.nodeEngine.getSerializationService().toData(object);
    }

    public void publishEvent(String cacheName, CacheEventType eventType, Data dataKey, Data dataValue, Data dataOldValue, boolean isOldValueAvailable, int orderKey) {
        IdentifiedDataSerializable eventData;
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations(SERVICE_NAME, cacheName);
        if (candidates.isEmpty()) {
            return;
        }
        switch (eventType) {
            case CREATED: 
            case UPDATED: 
            case REMOVED: 
            case EXPIRED: {
                CacheEventDataImpl cacheEventData = new CacheEventDataImpl(cacheName, eventType, dataKey, dataValue, dataOldValue, isOldValueAvailable);
                CacheEventSet eventSet = new CacheEventSet(eventType);
                eventSet.addEventData(cacheEventData);
                eventData = eventSet;
                break;
            }
            case EVICTED: {
                eventData = new CacheEventDataImpl(cacheName, CacheEventType.EVICTED, dataKey, null, null, false);
                break;
            }
            case INVALIDATED: {
                eventData = new CacheEventDataImpl(cacheName, CacheEventType.INVALIDATED, dataKey, null, null, false);
                break;
            }
            case COMPLETED: {
                eventData = new CacheEventDataImpl(cacheName, CacheEventType.COMPLETED, dataKey, dataValue, null, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Event Type not defined to create an eventData during publish : " + eventType.name());
            }
        }
        this.nodeEngine.getEventService().publishEvent(SERVICE_NAME, candidates, (Object)eventData, orderKey);
    }

    public void publishEvent(String cacheName, CacheEventSet eventSet, int orderKey) {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations(SERVICE_NAME, cacheName);
        if (candidates.isEmpty()) {
            return;
        }
        this.nodeEngine.getEventService().publishEvent(SERVICE_NAME, candidates, (Object)eventSet, orderKey);
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public void dispatchEvent(Object event, CacheEventListener listener) {
        listener.handleEvent(event);
    }

    public String registerListener(String distributedObjectName, CacheEventListener listener) {
        EventService eventService = this.getNodeEngine().getEventService();
        EventRegistration registration = eventService.registerListener(SERVICE_NAME, distributedObjectName, listener);
        return registration.getId();
    }

    public boolean deregisterListener(String name, String registrationId) {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.deregisterListener(SERVICE_NAME, name, registrationId);
    }

    public void deregisterAllListener(String name) {
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, name);
    }

    public CacheStatisticsImpl getStatistics(String name) {
        return (CacheStatisticsImpl)this.statistics.get(name);
    }
}

