/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.IParser;
import net.sf.jqql.packets.PacketHistory;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._03FamilyParser;
import net.sf.jqql.packets._05FamilyParser;
import net.sf.jqql.packets._08BasicFamilyParser;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PacketHelper {
    static Log log = LogFactory.getLog(PacketHelper.class);
    private IParser parser;
    private static final int PARSER_COUNT = 3;
    private int[] family = new int[]{1, 4, 2};
    private IParser[] parsers;

    public PacketHelper(int n) {
        this.parsers = new IParser[]{n * 1 != 0 ? new _08BasicFamilyParser() : null, n * 4 != 0 ? new _03FamilyParser() : null, n * 2 != 0 ? new _05FamilyParser() : null};
    }

    public _08OutPacket retrieveSent(_08InPacket _08InPacket2) {
        for (int i = 0; i < 3; ++i) {
            if (_08InPacket2.getFamily() != this.family[i]) continue;
            PacketHistory packetHistory = this.parsers[i].getHistory();
            if (packetHistory == null) {
                return null;
            }
            return packetHistory.retrieveSent(_08InPacket2);
        }
        return null;
    }

    public void putSent(_08OutPacket _08OutPacket2) {
        for (int i = 0; i < 3; ++i) {
            if (_08OutPacket2.getFamily() != this.family[i]) continue;
            PacketHistory packetHistory = this.parsers[i].getHistory();
            if (packetHistory == null) break;
            packetHistory.putSent(_08OutPacket2);
            break;
        }
    }

    public boolean isReplied(_08OutPacket _08OutPacket2, boolean bl) {
        for (int i = 0; i < 3; ++i) {
            if (_08OutPacket2.getFamily() != this.family[i]) continue;
            PacketHistory packetHistory = this.parsers[i].getHistory();
            if (packetHistory != null) {
                return packetHistory.check(_08OutPacket2, bl);
            }
            return false;
        }
        return false;
    }

    public boolean isDuplicated(_08InPacket _08InPacket2) {
        for (int i = 0; i < 3; ++i) {
            if (_08InPacket2.getFamily() != this.family[i]) continue;
            return this.parsers[i].isDuplicate(_08InPacket2);
        }
        return false;
    }

    public _08InPacket parseIn(int n, ByteBuffer byteBuffer, QQUser qQUser, boolean bl) throws PacketParseException {
        if (!this.findParser(n, byteBuffer)) {
            return null;
        }
        return this.parseIn(byteBuffer, this.parser.getLength(byteBuffer), qQUser, bl);
    }

    private boolean findParser(int n, ByteBuffer byteBuffer) {
        if (this.parser == null) {
            for (int i = 0; i < 3; ++i) {
                if ((n & this.family[i]) == 0 || !this.parsers[i].accept(byteBuffer)) continue;
                this.parser = this.parsers[i];
                break;
            }
        }
        return this.parser != null;
    }

    private _08InPacket parseIn(ByteBuffer byteBuffer, int n, QQUser qQUser, boolean bl) throws PacketParseException {
        int n2 = byteBuffer.position();
        try {
            _08InPacket _08InPacket2 = this.parser.parseIncoming(byteBuffer, n, qQUser);
            boolean bl2 = this.isDuplicated(_08InPacket2);
            boolean bl3 = this.parser.isDuplicatedNeedReply(_08InPacket2);
            if (bl2 && !bl3 && !bl) {
                _08InPacket _08InPacket3 = null;
                return _08InPacket3;
            }
            _08InPacket2.setDuplicated(bl2);
            _08InPacket _08InPacket4 = _08InPacket2;
            return _08InPacket4;
        }
        catch (PacketParseException packetParseException) {
            throw packetParseException;
        }
        finally {
            byteBuffer.position(n2 + n);
            this.parser = null;
        }
    }

    public _08OutPacket parseOut(int n, ByteBuffer byteBuffer, QQUser qQUser) throws PacketParseException {
        if (!this.findParser(n, byteBuffer)) {
            return null;
        }
        return this.parseOut(byteBuffer, this.parser.getLength(byteBuffer), qQUser);
    }

    private _08OutPacket parseOut(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        int n2 = byteBuffer.position();
        try {
            _08OutPacket _08OutPacket2;
            _08OutPacket _08OutPacket3 = _08OutPacket2 = this.parser.parseOutcoming(byteBuffer, n, qQUser);
            return _08OutPacket3;
        }
        catch (PacketParseException packetParseException) {
            throw packetParseException;
        }
        finally {
            byteBuffer.position(n2 + n);
            this.parser = null;
        }
    }

    public boolean relocate(int n, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.position();
        for (int i = 0; i < 3; ++i) {
            if ((n & this.family[i]) == 0) continue;
            int n3 = this.parsers[i].relocate(byteBuffer);
            if (n3 > n2) {
                byteBuffer.position(n3);
                return true;
            }
            return false;
        }
        return false;
    }
}

