/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform;

import com.install4j.api.JVMSelector;
import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.unix.UnixJVMLocator;
import com.install4j.runtime.installer.platform.win32.WinJVMLocator;
import java.io.File;
import java.util.List;

public class JVMLocator {
    public static JVMLocation[] getJVMLocations() {
        if (Util.isMacOS()) {
            return new JVMLocation[0];
        }
        List list = Util.isWindows() ? WinJVMLocator.getJVMLocations() : UnixJVMLocator.getJVMLocations();
        return list.toArray(new JVMLocation[list.size()]);
    }

    public static void main(String[] stringArray) {
        JVMLocation[] jVMLocationArray = JVMLocator.getJVMLocations();
        for (int i = 0; i < jVMLocationArray.length; ++i) {
            JVMLocation jVMLocation = jVMLocationArray[i];
            System.out.println(jVMLocation);
        }
    }

    public static class JVMLocation
    implements JVMSelector.JVMLocation {
        private File javaHome;
        private String version;
        private boolean jdk = false;

        public void setJavaHome(File file) {
            this.javaHome = file;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public void setJDK(boolean bl) {
            this.jdk = bl;
        }

        public File getJavaHome() {
            return this.javaHome;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isJDK() {
            return this.jdk;
        }

        public String toString() {
            return this.javaHome + ", version: " + this.version + " (" + (this.jdk ? "JDK" : "JRE") + ")";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof JVMLocation)) {
                return false;
            }
            JVMLocation jVMLocation = (JVMLocation)object;
            return !(this.javaHome != null ? !this.javaHome.equals(jVMLocation.javaHome) : jVMLocation.javaHome != null);
        }

        public int hashCode() {
            return this.javaHome != null ? this.javaHome.hashCode() : 0;
        }
    }
}

