/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import net.sf.jml.Email;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.exception.IncorrectPasswordException;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnOwnerImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingSYN;
import net.sf.jml.protocol.outgoing.OutgoingUSRAuthNS;
import net.sf.jml.util.JmlConstants;
import net.sf.jml.util.StringUtils;

public class IncomingUSR
extends MsnIncomingMessage {
    private static final Pattern passportUrlPattern = Pattern.compile(".*DALogin=([^,]*),.*");
    private static final Pattern ticketPattern = Pattern.compile(".*from-PP='([^']*)'.*");

    public IncomingUSR(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    private boolean isLoginSuccess() {
        return "OK".equals(this.getParam(0));
    }

    public String getAuthStr() {
        return this.getParam(2);
    }

    private boolean isLoginIntoSB() {
        return !this.getParam(this.getParamCount() - 1).equals("0");
    }

    public Email getEmail() {
        return Email.parseStr(this.getParam(1));
    }

    public String getDisplayName() {
        if (this.isLoginIntoSB() || this.protocol.before(MsnProtocol.MSNP10)) {
            return StringUtils.urlDecode(this.getParam(2));
        }
        return this.getEmail().getEmailAddress();
    }

    public boolean isVerified() {
        if (this.isLoginIntoSB()) {
            return true;
        }
        if (this.protocol.before(MsnProtocol.MSNP10)) {
            return "1".equals(this.getParam(3));
        }
        return "1".equals(this.getParam(2));
    }

    protected void messageReceived(MsnSession msnSession) {
        super.messageReceived(msnSession);
        MsnSwitchboard msnSwitchboard = msnSession.getSwitchboard();
        final MsnMessenger msnMessenger = msnSession.getMessenger();
        if (this.isLoginSuccess()) {
            if (this.isLoginIntoSB()) {
                if (msnSwitchboard != null) {
                    ((AbstractMessenger)msnMessenger).fireSwitchboardStarted(msnSwitchboard);
                }
            } else {
                MsnOwnerImpl msnOwnerImpl = (MsnOwnerImpl)msnMessenger.getOwner();
                msnOwnerImpl.setVerified(this.isVerified());
                msnOwnerImpl.fSetDisplayName(this.getDisplayName());
                ((AbstractMessenger)msnMessenger).fireLoginCompleted();
                OutgoingSYN outgoingSYN = new OutgoingSYN(this.protocol);
                outgoingSYN.setCachedVersion(msnMessenger.getContactList().getVersion());
                msnMessenger.send(outgoingSYN);
            }
        } else {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private String getPassportUrlSlow() throws IOException {
                    HttpURLConnection httpURLConnection = null;
                    try {
                        httpURLConnection = (HttpsURLConnection)new URL("https://nexus.passport.com/rdr/pprdr.asp").openConnection();
                        httpURLConnection.setUseCaches(false);
                        Matcher matcher = passportUrlPattern.matcher(httpURLConnection.getHeaderField("PassportURLs"));
                        if (matcher.matches()) {
                            String string = "https://" + matcher.group(1);
                            return string;
                        }
                        String string = null;
                        return string;
                    }
                    finally {
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                    }
                }

                private String getPassportUrl() throws IOException {
                    if (JmlConstants.FAST_SSL_LOGIN) {
                        return "https://loginnet.passport.com/login2.srf";
                    }
                    return this.getPassportUrlSlow();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private String getLoginTicket(String string, String string2, String string3, String string4) throws IOException {
                    HttpURLConnection httpURLConnection = null;
                    try {
                        httpURLConnection = (HttpsURLConnection)new URL(string).openConnection();
                        httpURLConnection.setUseCaches(false);
                        httpURLConnection.setRequestProperty("Authorization", "Passport1.4 OrgVerb=GET,OrgURL=http%3A%2F%2Fmessenger%2Emsn%2Ecom,sign-in=" + StringUtils.urlEncode(string2) + ",pwd=" + StringUtils.urlEncode(string3) + "," + string4);
                        switch (httpURLConnection.getResponseCode()) {
                            case 200: {
                                Matcher matcher = ticketPattern.matcher(httpURLConnection.getHeaderField("Authentication-Info"));
                                if (matcher.matches()) {
                                    String string5 = matcher.group(1);
                                    return string5;
                                }
                                String string6 = null;
                                return string6;
                            }
                            case 302: {
                                string = httpURLConnection.getHeaderField("Location");
                                String string7 = this.getLoginTicket(string, string2, string3, string4);
                                return string7;
                            }
                            case 401: {
                                String string8 = null;
                                return string8;
                            }
                        }
                        return null;
                    }
                    finally {
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                    }
                }

                public void run() {
                    try {
                        OutgoingUSRAuthNS outgoingUSRAuthNS = new OutgoingUSRAuthNS(IncomingUSR.this.protocol);
                        String string = this.getLoginTicket(this.getPassportUrl(), msnMessenger.getOwner().getEmail().getEmailAddress(), ((MsnOwnerImpl)msnMessenger.getOwner()).getPassword(), IncomingUSR.this.getAuthStr());
                        if (string == null) {
                            ((AbstractMessenger)msnMessenger).fireExceptionCaught(new IncorrectPasswordException());
                            return;
                        }
                        outgoingUSRAuthNS.setTicket(string);
                        msnMessenger.send(outgoingUSRAuthNS);
                    }
                    catch (IOException iOException) {
                        ((AbstractMessenger)msnMessenger).fireExceptionCaught(iOException);
                        msnMessenger.logout();
                    }
                }
            }.start();
        }
    }
}

