/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.AccessControl;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.Processor;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;

public class DefaultInterfaceProcessor
implements Processor {
    private static final String pathPrefix = "/gateway/dwr";
    private String overridePath = null;
    protected CreatorManager creatorManager = null;
    protected AccessControl accessControl = null;
    private boolean allowImpossibleTests = false;
    private JavascriptUtil jsutil = new JavascriptUtil();

    public void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathinfo = req.getPathInfo();
        String servletpath = req.getServletPath();
        if (pathinfo == null) {
            pathinfo = req.getServletPath();
            servletpath = "/";
        }
        String scriptname = pathinfo = pathinfo.replaceAll(pathPrefix, "");
        scriptname = LocalUtil.replace(scriptname, "/interface/", "");
        scriptname = LocalUtil.replace(scriptname, ".js", "");
        Creator creator = this.creatorManager.getCreator(scriptname);
        PrintWriter out = resp.getWriter();
        out.println();
        out.println("function " + scriptname + "() { }");
        String path = "/plugins/gateway/dwr";
        if (path == null) {
            path = req.getContextPath() + servletpath;
        }
        out.println(scriptname + "._path = '" + path + "';");
        Method[] methods = creator.getType().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int j;
            Method method = methods[i];
            String methodName = method.getName();
            String reason = this.accessControl.getReasonToNotDisplay(req, creator, scriptname, method);
            if (reason != null && !this.allowImpossibleTests || this.jsutil.isReservedWord(methodName)) continue;
            out.print('\n');
            out.print(scriptname + '.' + methodName + " = function(");
            Class<?>[] paramTypes = method.getParameterTypes();
            for (j = 0; j < paramTypes.length; ++j) {
                if (LocalUtil.isServletClass(paramTypes[j])) continue;
                out.print("p" + j + ", ");
            }
            out.println("callback) {");
            out.print("    DWREngine._execute(" + scriptname + "._path, '" + scriptname + "', '" + methodName + "', ");
            for (j = 0; j < paramTypes.length; ++j) {
                if (LocalUtil.isServletClass(paramTypes[j])) {
                    out.print("false, ");
                    continue;
                }
                out.print("p" + j + ", ");
            }
            out.println("callback);");
            out.println('}');
        }
        out.flush();
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }
}

