/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl.xa;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.impl.TransactionLog;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.transaction.impl.xa.XAService;
import com.hazelcast.transaction.impl.xa.XATransactionImpl;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class PutRemoteTransactionBackupOperation
extends Operation
implements BackupOperation {
    private final List<TransactionLog> txLogs = new LinkedList<TransactionLog>();
    private SerializableXID xid;
    private String txnId;
    private String txOwnerUuid;
    private long timeoutMillis;
    private long startTime;

    public PutRemoteTransactionBackupOperation() {
    }

    public PutRemoteTransactionBackupOperation(List<TransactionLog> logs, String txnId, SerializableXID xid, String txOwnerUuid, long timeoutMillis, long startTime) {
        this.txLogs.addAll(logs);
        this.txnId = txnId;
        this.xid = xid;
        this.txOwnerUuid = txOwnerUuid;
        this.timeoutMillis = timeoutMillis;
        this.startTime = startTime;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        XAService xaService = (XAService)this.getService();
        NodeEngine nodeEngine = this.getNodeEngine();
        XATransactionImpl transaction = new XATransactionImpl(nodeEngine, this.txLogs, this.txnId, this.xid, this.txOwnerUuid, this.timeoutMillis, this.startTime);
        xaService.putTransaction(transaction);
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.txnId);
        out.writeObject(this.xid);
        out.writeUTF(this.txOwnerUuid);
        out.writeLong(this.timeoutMillis);
        out.writeLong(this.startTime);
        int len = this.txLogs.size();
        out.writeInt(len);
        if (len > 0) {
            for (TransactionLog txLog : this.txLogs) {
                out.writeObject(txLog);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.txnId = in.readUTF();
        this.xid = (SerializableXID)in.readObject();
        this.txOwnerUuid = in.readUTF();
        this.timeoutMillis = in.readLong();
        this.startTime = in.readLong();
        int len = in.readInt();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                TransactionLog txLog = (TransactionLog)in.readObject();
                this.txLogs.add(txLog);
            }
        }
    }
}

