/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.util;

public class WaveUtils {
    private static int[] exp_lut2 = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final boolean ZEROTRAP = true;
    private static final int CLIP = 32625;
    private static final int BIAS = 132;
    private static final int[] expLut = new int[]{0, 132, 396, 924, 1980, 4092, 8316, 16764};

    public static final byte shortToUlaw(short sampleData) {
        int mantissa;
        int exponent;
        int ulawByte;
        int sample = sampleData;
        int sign = sample >> 8 & 0x80;
        if (sign != 0) {
            sample = -sample;
        }
        if (sample > 32625) {
            sample = 32625;
        }
        if ((ulawByte = ~(sign | (exponent = exp_lut2[(sample += 132) >> 7 & 0xFF]) << 4 | (mantissa = sample >> exponent + 3 & 0xF))) == 0) {
            ulawByte = 2;
        }
        return (byte)(ulawByte - 128 & 0xFF);
    }

    public static final short ulawToShort(short uByte) {
        int ulawByte = uByte;
        int sign = (ulawByte ^= 0xFFFFFFFF) & 0x80;
        int exponent = ulawByte >> 4 & 7;
        int mantissa = ulawByte & 0xF;
        int sample = expLut[exponent] + (mantissa << exponent + 3);
        if (sign != 0) {
            sample = -sample;
        }
        return (short)sample;
    }

    public static final short bytesToShort(byte hiByte, byte loByte) {
        int result = 0xFF & hiByte;
        result <<= 8;
        return (short)(result |= 0xFF & loByte);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 256; ++i) {
            System.out.println("" + i + "=" + WaveUtils.ulawToShort((short)i));
        }
    }
}

