/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.diphone;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.diphone.Diphone;
import com.sun.speech.freetts.diphone.DiphoneUnit;
import com.sun.speech.freetts.diphone.DiphoneUnitDatabase;
import com.sun.speech.freetts.relp.SampleInfo;
import java.io.IOException;
import java.net.URL;

public class DiphoneUnitSelector
implements UtteranceProcessor {
    private DiphoneUnitDatabase diphoneDatabase;

    public DiphoneUnitSelector(URL url) throws IOException {
        if (url == null) {
            throw new IOException("Can't load unit database");
        }
        boolean binary = url.getPath().endsWith(".bin");
        this.diphoneDatabase = new DiphoneUnitDatabase(url, binary);
    }

    public SampleInfo getSampleInfo() {
        return this.diphoneDatabase.getSampleInfo();
    }

    @Override
    public void processUtterance(Utterance utterance) throws ProcessException {
        if (utterance.getRelation("Segment") == null) {
            throw new IllegalStateException("DiphoneUnitSelector: Segment relation does not exist");
        }
        utterance.setObject("SampleInfo", this.diphoneDatabase.getSampleInfo());
        this.createUnitRelation(utterance);
    }

    private void createUnitRelation(Utterance utterance) {
        Relation unitRelation = utterance.createRelation("Unit");
        Relation segmentRelation = utterance.getRelation("Segment");
        Item segmentItem0 = segmentRelation.getHead();
        while (segmentItem0 != null && segmentItem0.getNext() != null) {
            Item segmentItem1 = segmentItem0.getNext();
            String diphoneName = segmentItem0.getFeatures().getString("name") + "-" + segmentItem1.getFeatures().getString("name");
            float end0 = segmentItem0.getFeatures().getFloat("end");
            int targetEnd = (int)(end0 * (float)this.diphoneDatabase.getSampleInfo().getSampleRate());
            Item unitItem0 = this.createUnitItem(unitRelation, diphoneName, targetEnd, 1);
            segmentItem0.addDaughter(unitItem0);
            float end1 = segmentItem1.getFeatures().getFloat("end");
            targetEnd = (int)((double)(end0 + end1) / 2.0 * (double)this.diphoneDatabase.getSampleInfo().getSampleRate());
            Item unitItem1 = this.createUnitItem(unitRelation, diphoneName, targetEnd, 2);
            segmentItem1.addDaughter(unitItem1);
            segmentItem0 = segmentItem1;
        }
    }

    private Item createUnitItem(Relation unitRelation, String diphoneName, int targetEnd, int unitPart) {
        Diphone diphone = this.diphoneDatabase.getUnit(diphoneName);
        if (diphone == null) {
            System.err.println("FreeTTS: unit database failed to find entry for: " + diphoneName);
        }
        Item unit = unitRelation.appendItem();
        FeatureSet unitFeatureSet = unit.getFeatures();
        unitFeatureSet.setString("name", diphoneName);
        unitFeatureSet.setInt("target_end", targetEnd);
        unitFeatureSet.setObject("unit", new DiphoneUnit(diphone, unitPart));
        return unit;
    }

    public String toString() {
        return "DiphoneUnitSelector";
    }
}

