/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web;

import com.voxeo.utils.Objects;
import com.voxeo.utils.Strings;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseHeaderSettingFilter
implements Filter {
    private String headerName;
    private Resolver resolver;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        String value;
        if (request instanceof HttpServletRequest && !Strings.isEmpty(value = this.resolver.resolve(httpRequest = (HttpServletRequest)request))) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader(this.headerName, value);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        this.headerName = config.getInitParameter("headerName");
        String resolverClassName = config.getInitParameter("resolverClass");
        try {
            Resolver resolver;
            this.resolver = resolver = (Resolver)Objects.make(resolverClassName, new Object[0]);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public void destroy() {
    }

    public static interface Resolver {
        public String resolve(HttpServletRequest var1);
    }
}

