/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class VerboseLock
implements Lock {
    private static final Loggerf log = Loggerf.getLogger(VerboseLock.class);
    private final Lock delegate;

    public VerboseLock(Lock delegate) {
        this.delegate = delegate;
    }

    public void lock() {
        log.trace("Locking %s", this);
        this.delegate.lock();
    }

    public void lockInterruptibly() throws InterruptedException {
        log.trace("Locking interruptibly %s", this);
        this.delegate.lockInterruptibly();
    }

    public Condition newCondition() {
        log.trace("Acquiring new condition for lock %s", this);
        return this.delegate.newCondition();
    }

    public boolean tryLock() {
        log.trace("Trying lock on %s", this);
        return this.delegate.tryLock();
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        log.trace("Trying lock on %s with timeout %d %s", new Object[]{this, time, unit});
        return this.delegate.tryLock();
    }

    public void unlock() {
        log.trace("Unlocking %s", this);
        this.delegate.unlock();
    }
}

