/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWhich {
    public static URL findClass(Class<?> clazz) {
        return JWhich.findClass(clazz.getName());
    }

    public static URL findClass(String className) {
        String resourceName = JWhich.asResourceName(className, true);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URL resource = null;
        if (contextClassLoader != null) {
            resource = contextClassLoader.getResource(resourceName);
        }
        if (contextClassLoader == null || resource == null) {
            resource = JWhich.class.getResource(resourceName);
        }
        return resource;
    }

    protected static String asResourceName(String resource, boolean prependSlash) {
        return String.format("%s%s.class", prependSlash ? "/" : "", resource.replace('.', '/'));
    }

    public static void main(String[] args) throws MalformedURLException {
        System.out.println(JWhich.findClass("java.lang.String"));
        if (args.length < 1) {
            System.err.println("Not enough args");
            return;
        }
        URL[] files = new URL[args.length - 1];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(args[i + 1]).toURL();
        }
        URLClassLoader loader = new URLClassLoader(files, Thread.currentThread().getContextClassLoader());
        String resourceName = JWhich.asResourceName(args[0], false);
        System.out.println(loader.getResource(resourceName));
    }
}

