/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

public class GrowingCharArray {
    private char[] chars;
    private int head;

    public GrowingCharArray() {
        this(500);
    }

    public GrowingCharArray(int initialsize) {
        this.chars = new char[initialsize];
    }

    public GrowingCharArray add(char b) {
        if (this.head + 1 == this.chars.length) {
            this.grow(this.chars.length);
        }
        this.chars[this.head++] = b;
        return this;
    }

    public GrowingCharArray add(GrowingCharArray growingByteArray) {
        if (this.head + growingByteArray.head + 1 > this.chars.length) {
            this.grow(growingByteArray.head);
        }
        System.arraycopy(growingByteArray.chars, 0, this.chars, this.head, growingByteArray.head);
        this.head += growingByteArray.head;
        return this;
    }

    public GrowingCharArray add(char[] chararray) {
        if (this.head + chararray.length + 1 > this.chars.length) {
            this.grow(chararray.length);
        }
        System.arraycopy(chararray, 0, this.chars, this.head, chararray.length);
        this.head += chararray.length;
        return this;
    }

    public char[] get() {
        char[] result = new char[this.head];
        System.arraycopy(this.chars, 0, result, 0, this.head);
        return result;
    }

    private GrowingCharArray grow(int size) {
        char[] newChars = new char[this.chars.length + size];
        System.arraycopy(this.chars, 0, newChars, 0, this.head);
        this.chars = newChars;
        return this;
    }

    public int length() {
        return this.head;
    }

    public GrowingCharArray reset() {
        this.head = 0;
        return this;
    }

    public String toString() {
        return new String(this.chars, 0, this.head);
    }
}

