/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import com.voxeo.logging.EncodedLoggingEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class EncodedPatternLayout
extends PatternLayout {
    private static final String hostName;
    private int maxMessageSize = 0;

    public boolean ignoresThrowable() {
        return false;
    }

    public String format(LoggingEvent event) {
        return super.format((LoggingEvent)new EncodedLoggingEvent(event, this.maxMessageSize));
    }

    public void setConversionPattern(String conversionPattern) {
        super.setConversionPattern(conversionPattern == null ? null : conversionPattern.replace("%X{HostName}", hostName));
    }

    public void setMaxMessageSize(String value) {
        this.maxMessageSize = this.toMessageSize(value, 0);
    }

    private int toMessageSize(String value, int dEfault) {
        if (value == null) {
            return dEfault;
        }
        String s = value.trim().toUpperCase();
        long multiplier = 1L;
        int index = s.indexOf("KB");
        if (index != -1) {
            multiplier = 1024L;
            s = s.substring(0, index);
        } else {
            index = s.indexOf("MB");
            if (index != -1) {
                multiplier = 0x100000L;
                s = s.substring(0, index);
            } else {
                index = s.indexOf("GB");
                if (index != -1) {
                    multiplier = 0x40000000L;
                    s = s.substring(0, index);
                }
            }
        }
        if (s != null) {
            try {
                int i = (int)((long)Integer.valueOf(s).intValue() * multiplier);
                if (i < 0) {
                    return dEfault;
                }
                return i;
            }
            catch (NumberFormatException e) {
                LogLog.error((String)("[" + s + "] is not in proper int form."));
                LogLog.error((String)("[" + value + "] not in expected format."), (Throwable)e);
            }
        }
        return dEfault;
    }

    public String getMaxMessageSize() {
        return Long.toString(this.maxMessageSize);
    }

    static {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "Unknown";
        }
        hostName = hostname;
    }
}

