/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.xml;

import com.rayo.core.validation.ValidationException;
import com.rayo.core.xml.XmlProvider;
import com.rayo.core.xml.XmlProviderManager;
import com.voxeo.utils.Objects;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class DefaultXmlProviderManager
implements XmlProviderManager {
    private List<XmlProvider> providers = new CopyOnWriteArrayList<XmlProvider>();

    @Override
    public Element toXML(Object object) {
        Objects.assertion((object != null ? 1 : 0) != 0, (String)"Cannot serialize null reference", (Object[])new Object[0]);
        for (XmlProvider provider : this.providers) {
            Element element;
            if (!provider.handles(object.getClass()) || (element = provider.toXML(object)) == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public <T> T fromXML(Element element) {
        Objects.assertion((element != null ? 1 : 0) != 0, (String)"Cannot deserialize null reference", (Object[])new Object[0]);
        for (XmlProvider provider : this.providers) {
            Object object;
            if (!provider.handles(element) || (object = provider.fromXML(element)) == null) continue;
            return object;
        }
        throw new ValidationException("Could not find the element on namespace.");
    }

    @Override
    public boolean handles(Element element) {
        for (XmlProvider provider : this.providers) {
            if (!provider.handles(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handles(Class<?> clazz) {
        for (XmlProvider provider : this.providers) {
            if (!provider.handles(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handles(Namespace namespace) {
        return this.findProvider(namespace) != null;
    }

    @Override
    public XmlProvider findProvider(Namespace namespace) {
        for (XmlProvider provider : this.providers) {
            if (!provider.handles(namespace)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public void register(XmlProvider provider) {
        this.providers.add(provider);
        provider.setManager(this);
    }

    @Override
    public void unregister(XmlProvider provider) {
        this.providers.remove(provider);
    }

    @Override
    public XmlProviderManager getManager() {
        return this;
    }

    @Override
    public void setManager(XmlProviderManager manager) {
        throw new UnsupportedOperationException("This is already a root manager");
    }
}

