/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import com.voxeo.logging.ILoggerf;
import com.voxeo.utils.Strings;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loggerf
implements ILoggerf {
    private Logger logger;
    private final boolean traceAvailable;

    private Loggerf(Logger logger) {
        this.logger = logger;
        try {
            logger.isTraceEnabled();
        }
        catch (NoSuchMethodError e) {
            this.traceAvailable = false;
            return;
        }
        this.traceAvailable = true;
    }

    public static Loggerf getLogger(Class<?> clazz) {
        return new Loggerf(Logger.getLogger(clazz));
    }

    public static Loggerf getLogger(String category) {
        return new Loggerf(Logger.getLogger((String)category));
    }

    public static Loggerf getLogger(Logger logger) {
        return new Loggerf(logger);
    }

    public void trace(String message, Object ... args) {
        if (!this.traceAvailable) {
            this.debug(message, args);
        } else if (this.logger.isTraceEnabled()) {
            message = Strings.format(message, args);
            Throwable throwable = this.extractThrowable(args);
            if (throwable != null) {
                this.logger.trace((Object)message, throwable);
            } else {
                this.logger.trace((Object)message);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            message = Strings.format(message, args);
            Throwable throwable = this.extractThrowable(args);
            if (throwable != null) {
                this.logger.debug((Object)message, throwable);
            } else {
                this.logger.debug((Object)message);
            }
        }
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            message = Strings.format(message, args);
            Throwable throwable = this.extractThrowable(args);
            if (throwable != null) {
                this.logger.info((Object)message, throwable);
            } else {
                this.logger.info((Object)message);
            }
        }
    }

    public void error(Throwable t) {
        this.error(t.getMessage(), t);
    }

    @Override
    public void error(String message, Object ... args) {
        Throwable throwable;
        if (message != null) {
            message = Strings.format(message, args);
        }
        if ((throwable = this.extractThrowable(args)) != null) {
            this.logger.error((Object)message, throwable);
        } else {
            this.logger.error((Object)message);
        }
    }

    public void fatal(Throwable t) {
        this.error(t.getMessage(), t);
    }

    @Override
    public void fatal(String message, Object ... args) {
        message = Strings.format(message, args);
        Throwable throwable = this.extractThrowable(args);
        if (throwable != null) {
            this.logger.fatal((Object)message, throwable);
        } else {
            this.logger.fatal((Object)message);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        message = Strings.format(message, args);
        Throwable throwable = this.extractThrowable(args);
        if (throwable != null) {
            this.logger.warn((Object)message, throwable);
        } else {
            this.logger.warn((Object)message);
        }
    }

    private Throwable extractThrowable(Object ... args) {
        Object o;
        Throwable throwable = null;
        if (args.length > 0 && (o = args[args.length - 1]) instanceof Throwable) {
            throwable = (Throwable)o;
        }
        return throwable;
    }

    public boolean isTraceEnabled() {
        if (this.traceAvailable) {
            return this.logger.isTraceEnabled();
        }
        return this.logger.isDebugEnabled();
    }
}

