/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.Random;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil;
    public static final boolean fsIsIgnoreCase;
    public static final boolean fsNormalizesPosixSeparator;
    static final Random random;

    FileUtil() {
    }

    public static FileUtil getDefaultInstance() {
        if (fileUtil == null) {
            fileUtil = new FileUtil();
        }
        return fileUtil;
    }

    public boolean isStreamElement(String string) {
        return new File(string).exists();
    }

    public InputStream openInputStreamElement(String string) throws IOException {
        try {
            return new FileInputStream(new File(string));
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    public void createParentDirs(String string) {
        FileUtil.makeParentDirectories(new File(string));
    }

    public void removeElement(String string) throws NoSuchElementException, IOException {
        if (this.isStreamElement(string)) {
            FileUtil.delete(string);
        }
    }

    public void renameElement(String string, String string2) throws NoSuchElementException, IOException {
        FileUtil.renameOverwrite(string, string2);
    }

    public OutputStream openOutputStreamElement(String string) throws IOException {
        return new FileOutputStream(new File(string));
    }

    public static void delete(String string) {
        new File(string).delete();
    }

    public static void deleteOnExit(File file) {
        JavaSystem.deleteOnExit(file);
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public static boolean exists(String string, boolean bl, Class clazz) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return bl ? null != clazz.getResource(string) : FileUtil.exists(string);
    }

    public static void renameOverwrite(String string, String string2) {
        FileUtil.delete(string2);
        if (FileUtil.exists(string)) {
            File file = new File(string);
            file.renameTo(new File(string2));
        }
    }

    public static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable.getMessage());
    }

    public static String absolutePath(String string) {
        return new File(string).getAbsolutePath();
    }

    public static File canonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public static File canonicalFile(String string) throws IOException {
        return new File(new File(string).getCanonicalPath());
    }

    public static String canonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    public static String canonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public static String canonicalOrAbsolutePath(String string) {
        try {
            return FileUtil.canonicalPath(string);
        }
        catch (Exception exception) {
            return FileUtil.absolutePath(string);
        }
    }

    public static void makeParentDirectories(File file) {
        String string = file.getParent();
        if (string != null) {
            new File(string).mkdirs();
        } else {
            string = file.getPath();
            int n = string.lastIndexOf(47);
            if (n > 0) {
                string = string.substring(0, n);
                new File(string).mkdirs();
            }
        }
    }

    public FileAccess.FileSync getFileSync(OutputStream outputStream) throws IOException {
        return new FileSync((FileOutputStream)outputStream);
    }

    static {
        fsIsIgnoreCase = new File("A").equals(new File("a"));
        fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
        random = new Random(System.currentTimeMillis());
    }

    public class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream fileOutputStream) throws IOException {
            this.outDescriptor = fileOutputStream.getFD();
        }

        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }
}

