/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.plugin.rest.entity.SystemProperties;
import org.jivesoftware.openfire.plugin.rest.entity.SystemProperty;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;
import org.jivesoftware.openfire.plugin.rest.service.JerseyWrapper;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.StringUtils;

public class RESTServicePlugin
implements Plugin,
PropertyEventListener {
    public static final RESTServicePlugin INSTANCE = new RESTServicePlugin();
    private static final String CUSTOM_AUTH_FILTER_PROPERTY_NAME = "plugin.restapi.customAuthFilter";
    private String secret;
    private Collection<String> allowedIPs;
    private boolean enabled;
    private String httpAuth;
    private String customAuthFilterClassName;

    public static RESTServicePlugin getInstance() {
        return INSTANCE;
    }

    public void initializePlugin(PluginManager manager, File pluginDirectory) {
        this.secret = JiveGlobals.getProperty((String)"plugin.restapi.secret", (String)"");
        if ("".equals(this.secret)) {
            this.secret = StringUtils.randomString((int)16);
            this.setSecret(this.secret);
        }
        this.customAuthFilterClassName = JiveGlobals.getProperty((String)CUSTOM_AUTH_FILTER_PROPERTY_NAME, (String)"");
        this.enabled = JiveGlobals.getBooleanProperty((String)"plugin.restapi.enabled", (boolean)false);
        this.httpAuth = JiveGlobals.getProperty((String)"plugin.restapi.httpAuth", (String)"basic");
        this.allowedIPs = StringUtils.stringToCollection((String)JiveGlobals.getProperty((String)"plugin.restapi.allowedIPs", (String)""));
        PropertyEventDispatcher.addListener((PropertyEventListener)this);
    }

    public void destroyPlugin() {
        PropertyEventDispatcher.removeListener((PropertyEventListener)this);
    }

    public SystemProperties getSystemProperties() {
        SystemProperties systemProperties = new SystemProperties();
        ArrayList<SystemProperty> propertiesList = new ArrayList<SystemProperty>();
        for (String propertyKey : JiveGlobals.getPropertyNames()) {
            String propertyValue = JiveGlobals.getProperty((String)propertyKey);
            propertiesList.add(new SystemProperty(propertyKey, propertyValue));
        }
        systemProperties.setProperties(propertiesList);
        return systemProperties;
    }

    public SystemProperty getSystemProperty(String propertyKey) throws ServiceException {
        String propertyValue = JiveGlobals.getProperty((String)propertyKey);
        if (propertyValue != null) {
            return new SystemProperty(propertyKey, propertyValue);
        }
        throw new ServiceException("Could not find property", propertyKey, "PropertyNotFoundException", Response.Status.NOT_FOUND);
    }

    public void createSystemProperty(SystemProperty systemProperty) {
        JiveGlobals.setProperty((String)systemProperty.getKey(), (String)systemProperty.getValue());
    }

    public void deleteSystemProperty(String propertyKey) throws ServiceException {
        if (JiveGlobals.getProperty((String)propertyKey) == null) {
            throw new ServiceException("Could not find property", propertyKey, "PropertyNotFoundException", Response.Status.NOT_FOUND);
        }
        JiveGlobals.deleteProperty((String)propertyKey);
    }

    public void updateSystemProperty(String propertyKey, SystemProperty systemProperty) throws ServiceException {
        if (JiveGlobals.getProperty((String)propertyKey) != null) {
            if (!systemProperty.getKey().equals(propertyKey)) {
                throw new ServiceException("Path property name and entity property name doesn't match", propertyKey, "IllegalArgumentException", Response.Status.BAD_REQUEST);
            }
        } else {
            throw new ServiceException("Could not find property for update", systemProperty.getKey(), "PropertyNotFoundException", Response.Status.NOT_FOUND);
        }
        JiveGlobals.setProperty((String)propertyKey, (String)systemProperty.getValue());
    }

    public String getLoadingStatusMessage() {
        return JerseyWrapper.getLoadingStatusMessage();
    }

    public String loadAuthenticationFilter(String customAuthFilterClassName) {
        return JerseyWrapper.tryLoadingAuthenticationFilter(customAuthFilterClassName);
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        JiveGlobals.setProperty((String)"plugin.restapi.secret", (String)secret);
        this.secret = secret;
    }

    public String getCustomAuthFilterClassName() {
        return this.customAuthFilterClassName;
    }

    public void setCustomAuthFiIterClassName(String customAuthFilterClassName) {
        JiveGlobals.setProperty((String)CUSTOM_AUTH_FILTER_PROPERTY_NAME, (String)customAuthFilterClassName);
        this.customAuthFilterClassName = customAuthFilterClassName;
    }

    public Collection<String> getAllowedIPs() {
        return this.allowedIPs;
    }

    public void setAllowedIPs(Collection<String> allowedIPs) {
        JiveGlobals.setProperty((String)"plugin.restapi.allowedIPs", (String)StringUtils.collectionToString(allowedIPs));
        this.allowedIPs = allowedIPs;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        JiveGlobals.setProperty((String)"plugin.restapi.enabled", (String)(enabled ? "true" : "false"));
    }

    public String getHttpAuth() {
        return this.httpAuth;
    }

    public void setHttpAuth(String httpAuth) {
        this.httpAuth = httpAuth;
        JiveGlobals.setProperty((String)"plugin.restapi.httpAuth", (String)httpAuth);
    }

    public void propertySet(String property, Map<String, Object> params) {
        if (property.equals("plugin.restapi.secret")) {
            this.secret = (String)params.get("value");
        } else if (property.equals("plugin.restapi.enabled")) {
            this.enabled = Boolean.parseBoolean((String)params.get("value"));
        } else if (property.equals("plugin.restapi.allowedIPs")) {
            this.allowedIPs = StringUtils.stringToCollection((String)((String)params.get("value")));
        } else if (property.equals("plugin.restapi.httpAuth")) {
            this.httpAuth = (String)params.get("value");
        } else if (property.equals(CUSTOM_AUTH_FILTER_PROPERTY_NAME)) {
            this.customAuthFilterClassName = (String)params.get("value");
        }
    }

    public void propertyDeleted(String property, Map<String, Object> params) {
        if (property.equals("plugin.restapi.secret")) {
            this.secret = "";
        } else if (property.equals("plugin.restapi.enabled")) {
            this.enabled = false;
        } else if (property.equals("plugin.restapi.allowedIPs")) {
            this.allowedIPs = Collections.emptyList();
        } else if (property.equals("plugin.restapi.httpAuth")) {
            this.httpAuth = "basic";
        } else if (property.equals(CUSTOM_AUTH_FILTER_PROPERTY_NAME)) {
            this.customAuthFilterClassName = null;
        }
    }

    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }
}

