/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler;

import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.backend.executor.NotChangedException;
import org.jolokia.config.ConfigKey;
import org.jolokia.request.JmxRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonRequestHandler<R extends JmxRequest> {
    private final Restrictor restrictor;

    protected JsonRequestHandler(Restrictor pRestrictor) {
        this.restrictor = pRestrictor;
    }

    public abstract RequestType getType();

    public boolean handleAllServersAtOnce(R pRequest) {
        return false;
    }

    public Object handleRequest(MBeanServerConnection pServer, R pRequest) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException, NotChangedException {
        this.checkForRestriction(pRequest);
        this.checkHttpMethod(pRequest);
        return this.doHandleRequest(pServer, pRequest);
    }

    protected abstract void checkForRestriction(R var1);

    protected void checkType() {
        if (!this.restrictor.isTypeAllowed(this.getType())) {
            throw new SecurityException("Command type " + (Object)((Object)this.getType()) + " not allowed due to policy used");
        }
    }

    private void checkHttpMethod(R pRequest) {
        if (!this.restrictor.isHttpMethodAllowed(((JmxRequest)pRequest).getHttpMethod())) {
            throw new SecurityException("HTTP method " + ((JmxRequest)pRequest).getHttpMethod().getMethod() + " is not allowed according to the installed security policy");
        }
    }

    protected abstract Object doHandleRequest(MBeanServerConnection var1, R var2) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException, NotChangedException;

    public Object handleRequest(MBeanServerExecutor pServerManager, R request) throws ReflectionException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, IOException, NotChangedException {
        this.checkForRestriction(request);
        return this.doHandleRequest(pServerManager, request);
    }

    public Object doHandleRequest(MBeanServerExecutor serverManager, R request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException, NotChangedException {
        return null;
    }

    public boolean useReturnValueWithPath() {
        return true;
    }

    protected Restrictor getRestrictor() {
        return this.restrictor;
    }

    protected void checkForModifiedSince(MBeanServerExecutor pServerManager, JmxRequest pRequest) throws NotChangedException {
        int ifModifiedSince = pRequest.getParameterAsInt(ConfigKey.IF_MODIFIED_SINCE);
        if (!pServerManager.hasMBeansListChangedSince(ifModifiedSince)) {
            throw new NotChangedException(pRequest);
        }
    }
}

