/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;

public class BasicMarker
implements Marker {
    final String name;
    List children;
    final IMarkerFactory factory;

    BasicMarker(String name, IMarkerFactory factory) {
        this.name = name;
        this.factory = factory;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(Marker child) {
        if (child == null) {
            throw new NullPointerException("Null children cannot be added to a Marker.");
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(child);
    }

    public synchronized boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public synchronized Iterator iterator() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public synchronized boolean remove(Marker markerToRemove) {
        if (this.children == null) {
            return false;
        }
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Marker m = (Marker)this.children.get(i);
            if (m != markerToRemove) continue;
            return false;
        }
        return false;
    }

    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this == other) {
            return true;
        }
        if (this.hasChildren()) {
            for (int i = 0; i < this.children.size(); ++i) {
                Marker child = (Marker)this.children.get(i);
                if (!child.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String name) {
        if (name == null) {
            return false;
        }
        if (this.factory.exists(name)) {
            Marker other = this.factory.getMarker(name);
            return this.contains(other);
        }
        return false;
    }
}

