/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.in;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.IRemoteStatus;
import pl.mn.communicator.IUser;
import pl.mn.communicator.RemoteStatus;
import pl.mn.communicator.User;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGStatuses;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.in.GGIncomingPackage;

public class GGStatus
implements GGIncomingPackage,
GGStatuses {
    public static final int GG_STATUS = 2;
    private static final Log LOGGER = LogFactory.getLog((Class)GGStatus.class);
    private IUser m_user = null;
    private RemoteStatus m_status = null;

    public GGStatus(byte[] data) {
        this.handleUser(data);
        this.handleStatus(data);
    }

    public int getPacketType() {
        return 2;
    }

    public IUser getUser() {
        return this.m_user;
    }

    public IRemoteStatus getStatus() {
        return this.m_status;
    }

    private void handleUser(byte[] data) {
        int uin = GGUtils.byteToInt(data);
        int protocolStatus = GGUtils.unsignedByteToInt(data[4]);
        User.UserMode userMode = GGConversion.getUserMode(protocolStatus);
        this.m_user = new User(uin, userMode);
    }

    private void handleStatus(byte[] data) {
        int protocolStatus = GGUtils.unsignedByteToInt(data[4]);
        String description = null;
        long timeInMillis = -1L;
        if ((protocolStatus == 4 || protocolStatus == 5 || protocolStatus == 22 || protocolStatus == 21) && data.length > 8 + (description = GGUtils.bytezToString(data, 8)).length()) {
            int timeInSeconds = GGUtils.byteToInt(data, data.length - 4);
            timeInMillis = GGUtils.secondsToMillis(timeInSeconds);
        }
        this.m_status = GGConversion.getClientRemoteStatus(protocolStatus, description, timeInMillis);
    }
}

