/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresql.Driver;
import org.postgresql.util.MessageTranslator;
import org.postgresql.util.PSQLState;

public class PSQLException
extends SQLException {
    private String message;
    private PSQLState state;
    private static final Character MESSAGE_TYPE_S = new Character('S');
    private static final Character MESSAGE_TYPE_M = new Character('M');
    private static final Character MESSAGE_TYPE_D = new Character('D');
    private static final Character MESSAGE_TYPE_H = new Character('H');
    private static final Character MESSAGE_TYPE_P = new Character('P');
    private static final Character MESSAGE_TYPE_W = new Character('W');
    private static final Character MESSAGE_TYPE_F = new Character('F');
    private static final Character MESSAGE_TYPE_L = new Character('L');
    private static final Character MESSAGE_TYPE_R = new Character('R');
    private static final Character MESSAGE_TYPE_C = new Character('C');

    public PSQLException(String msg, PSQLState state) {
        this.state = state;
        this.translate(msg, null);
        if (Driver.logDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public PSQLException(String msg, PSQLState state, Object[] argv) {
        this.state = state;
        this.translate(msg, argv);
        if (Driver.logDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public PSQLException(String msg, PSQLState state, Object arg1) {
        this.state = state;
        Object[] argv = new Object[]{arg1};
        this.translate(msg, argv);
        if (Driver.logDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public PSQLException(String msg, PSQLState state, Object arg1, Object arg2) {
        this.state = state;
        Object[] argv = new Object[]{arg1, arg2};
        this.translate(msg, argv);
        if (Driver.logDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public static PSQLException parseServerError(String p_serverError) {
        if (Driver.logDebug) {
            Driver.debug("Constructing exception from server message: " + p_serverError);
        }
        char[] l_chars = p_serverError.toCharArray();
        int l_length = l_chars.length;
        Hashtable<Character, String> l_mesgParts = new Hashtable<Character, String>();
        for (int l_pos = 0; l_pos < l_length; ++l_pos) {
            char l_mesgType = l_chars[l_pos];
            if (l_mesgType == '\u0000') continue;
            int l_startString = ++l_pos;
            while (l_chars[l_pos] != '\u0000' && l_pos < l_length) {
                ++l_pos;
            }
            String l_mesgPart = new String(l_chars, l_startString, l_pos - l_startString);
            l_mesgParts.put(new Character(l_mesgType), l_mesgPart);
        }
        StringBuffer l_totalMessage = new StringBuffer();
        String l_message = (String)l_mesgParts.get(MESSAGE_TYPE_S);
        if (l_message != null) {
            l_totalMessage.append(l_message).append(": ");
        }
        if ((l_message = (String)l_mesgParts.get(MESSAGE_TYPE_M)) != null) {
            l_totalMessage.append(l_message).append('\n');
        }
        if (Driver.logInfo) {
            l_message = (String)l_mesgParts.get(MESSAGE_TYPE_D);
            if (l_message != null) {
                l_totalMessage.append("  ").append(MessageTranslator.translate("postgresql.error.detail", l_message)).append('\n');
            }
            if ((l_message = (String)l_mesgParts.get(MESSAGE_TYPE_H)) != null) {
                l_totalMessage.append("  ").append(MessageTranslator.translate("postgresql.error.hint", l_message)).append('\n');
            }
            if ((l_message = (String)l_mesgParts.get(MESSAGE_TYPE_P)) != null) {
                l_totalMessage.append("  ").append(MessageTranslator.translate("postgresql.error.position", l_message)).append('\n');
            }
            if ((l_message = (String)l_mesgParts.get(MESSAGE_TYPE_W)) != null) {
                l_totalMessage.append("  ").append(MessageTranslator.translate("postgresql.error.where", l_message)).append('\n');
            }
        }
        if (Driver.logDebug) {
            String l_file = (String)l_mesgParts.get(MESSAGE_TYPE_F);
            String l_line = (String)l_mesgParts.get(MESSAGE_TYPE_L);
            String l_routine = (String)l_mesgParts.get(MESSAGE_TYPE_R);
            if (l_file != null || l_line != null || l_routine != null) {
                l_totalMessage.append("  ").append(MessageTranslator.translate("postgresql.error.location", l_file + ":" + l_line + ":" + l_routine)).append('\n');
            }
            if ((l_message = (String)l_mesgParts.get(MESSAGE_TYPE_C)) != null) {
                l_totalMessage.append("  ").append("ServerSQLState: " + l_message).append('\n');
            }
        }
        PSQLException l_return = new PSQLException(l_totalMessage.toString(), PSQLState.UNKNOWN_STATE);
        l_return.state = new PSQLState((String)l_mesgParts.get(MESSAGE_TYPE_C));
        return l_return;
    }

    public PSQLException(String error) {
        this.translate(error, null);
        if (Driver.logDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public PSQLException(String error, Object arg) {
        Object[] argv = new Object[]{arg};
        this.translate(error, argv);
        if (Driver.logDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    private void translate(String error, Object[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Exception) || args[i] instanceof PSQLException) continue;
                Exception ex = (Exception)args[i];
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintWriter pw = new PrintWriter(baos);
                    pw.println("Exception: " + ex.toString() + "\nStack Trace:\n");
                    ex.printStackTrace(pw);
                    pw.println("End of Stack Trace");
                    pw.flush();
                    args[i] = baos.toString();
                    pw.close();
                    baos.close();
                    continue;
                }
                catch (Exception ioe) {
                    args[i] = ex.toString() + "\nIO Error on stack trace generation! " + ioe.toString();
                }
            }
        }
        this.message = MessageTranslator.translate(error, args);
    }

    public String getLocalizedMessage() {
        return this.message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSQLState() {
        if (this.state == null) {
            return PSQLState.UNKNOWN_STATE.getState();
        }
        return this.state.getState();
    }
}

