/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sentinel.protocols;

import com.voxeo.sentinel.client.SentinelClient;
import com.voxeo.sentinel.protocols.SentinelDecoder;
import com.voxeo.sentinel.protocols.SentinelEncoder;
import com.voxeo.utils.MemoryMonitor;
import com.voxeo.utils.StackTraceMonitor;
import com.voxeo.versioning.Module;
import java.io.BufferedReader;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

public class SentinelClientProtocol {
    private static final Logger Log = Logger.getLogger(SentinelClientProtocol.class);
    protected final int ACK = 0;
    public final int HNDSHK = 1;
    public final int SNDOBJ = 2;
    public final int DONE = 3;
    private int state = 0;
    private SentinelDecoder in = null;
    private SentinelEncoder out = null;
    private SentinelClient localClient = null;
    private final StackTraceMonitor stackTraceMonitor = new StackTraceMonitor();

    public SentinelClientProtocol(BufferedReader in, PrintWriter out, SentinelClient localClient) {
        this.in = new SentinelDecoder(in, false);
        this.out = new SentinelEncoder(out, false);
        this.localClient = localClient;
    }

    public boolean sndModule() {
        boolean returnValue = false;
        this.state = 0;
        while (this.in.getMsg(this.state)) {
            Log.debug((Object)("CLIENT IS IN STATE " + this.state));
            if (this.state == 2) {
                Module module = this.localClient.getModule();
                module.setMemory(MemoryMonitor.getAsText());
                module.setStackTrace(this.stackTraceMonitor.getStackTraceString());
                this.out.sendCustomMsg(module.toXML());
            } else {
                this.out.sendMsg(this.state);
            }
            if (this.state >= 3) {
                this.state = 0;
                this.localClient.setSocketTO(0);
                continue;
            }
            ++this.state;
        }
        Log.debug((Object)"\n\nOUT OF THE LOOP\n\n");
        return returnValue;
    }
}

