/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jqql.net.AbstractPort;
import net.sf.jqql.net.IConnection;
import net.sf.jqql.net.IConnectionPolicy;
import net.sf.jqql.net.IConnectionPool;
import net.sf.jqql.net.IPort;
import net.sf.jqql.net.IProxyHandler;
import net.sf.jqql.net.Porter;
import net.sf.jqql.net.ProxyVerifier;
import net.sf.jqql.net.TCPHttpPort;
import net.sf.jqql.net.TCPPort;
import net.sf.jqql.net.TCPSocks5Port;
import net.sf.jqql.net.UDPPort;
import net.sf.jqql.net.UDPSocks5Port;
import net.sf.jqql.packets._08OutPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortGate
implements IConnectionPool {
    private Map<String, IPort> registry;
    private Map<IConnection, Integer> references;
    private Porter porter = new Porter();

    public PortGate() {
        this.registry = new HashMap<String, IPort>();
        this.references = new HashMap<IConnection, Integer>();
    }

    @Override
    public void start() {
        this.porter.start();
    }

    @Override
    public synchronized List<IConnection> getConnections() {
        ArrayList<IConnection> arrayList = new ArrayList<IConnection>();
        arrayList.addAll(this.registry.values());
        return arrayList;
    }

    @Override
    public synchronized boolean hasConnection(String string) {
        return this.registry.containsKey(string);
    }

    @Override
    public synchronized void release(IConnection iConnection) {
        if (iConnection == null) {
            return;
        }
        Integer n = this.references.get(iConnection);
        if (n == null) {
            return;
        }
        Integer n2 = n;
        Integer n3 = n = Integer.valueOf(n - 1);
        if (n <= 0) {
            this.references.remove(iConnection);
            this.registry.remove(iConnection.getId());
            this.porter.addDisposeRequest((IPort)iConnection);
        } else {
            this.references.put(iConnection, n);
        }
    }

    @Override
    public synchronized void release(String string) {
        IConnection iConnection = this.getConnection(string);
        this.release(iConnection);
    }

    @Override
    public synchronized IConnection getConnection(String string) {
        return this.registry.get(string);
    }

    @Override
    public synchronized IConnection getConnection(InetSocketAddress inetSocketAddress) {
        for (IPort iPort : this.registry.values()) {
            if (!iPort.getRemoteAddress().equals(inetSocketAddress)) continue;
            return iPort;
        }
        return null;
    }

    private synchronized void increaseReference(IConnection iConnection) {
        Integer n = this.references.get(iConnection);
        if (n != null) {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
            this.references.put(iConnection, n);
        }
    }

    @Override
    public void send(String string, _08OutPacket _08OutPacket2, boolean bl) {
        IConnection iConnection = this.getConnection(string);
        if (iConnection != null) {
            if (bl) {
                iConnection.getPolicy().putSent(_08OutPacket2);
            }
            iConnection.add(_08OutPacket2);
        }
    }

    @Override
    public synchronized IConnection newUDPConnection(IConnectionPolicy iConnectionPolicy, InetSocketAddress inetSocketAddress, boolean bl) {
        IConnection iConnection;
        if (this.hasConnection(iConnectionPolicy.getConnectionId())) {
            iConnection = this.getConnection(iConnectionPolicy.getConnectionId());
            this.increaseReference(iConnection);
        }
        try {
            iConnection = new UDPPort(iConnectionPolicy, inetSocketAddress);
        }
        catch (IOException iOException) {
            return null;
        }
        ((AbstractPort)iConnection).setPool(this);
        this.registry.put(iConnectionPolicy.getConnectionId(), (IPort)iConnection);
        this.references.put(iConnection, 1);
        this.porter.wakeup(iConnection);
        if (bl) {
            ((UDPPort)iConnection).start();
        }
        return iConnection;
    }

    @Override
    public synchronized IConnection newUDPSocks5Connection(IConnectionPolicy iConnectionPolicy, InetSocketAddress inetSocketAddress, boolean bl) {
        IConnection iConnection;
        if (this.hasConnection(iConnectionPolicy.getConnectionId())) {
            iConnection = this.getConnection(iConnectionPolicy.getConnectionId());
            this.increaseReference(iConnection);
        }
        try {
            iConnection = new UDPSocks5Port(iConnectionPolicy, inetSocketAddress);
        }
        catch (IOException iOException) {
            return null;
        }
        ((AbstractPort)iConnection).setPool(this);
        this.registry.put(iConnectionPolicy.getConnectionId(), (IPort)iConnection);
        this.references.put(iConnection, 1);
        this.porter.wakeup(iConnection);
        if (bl) {
            ((UDPSocks5Port)iConnection).start();
        }
        return iConnection;
    }

    @Override
    public synchronized IConnection newTCPConnection(IConnectionPolicy iConnectionPolicy, InetSocketAddress inetSocketAddress, boolean bl) {
        IConnection iConnection;
        if (this.hasConnection(iConnectionPolicy.getConnectionId())) {
            iConnection = this.getConnection(iConnectionPolicy.getConnectionId());
            this.increaseReference(iConnection);
        }
        try {
            iConnection = new TCPPort(iConnectionPolicy, inetSocketAddress);
        }
        catch (IOException iOException) {
            return null;
        }
        ((AbstractPort)iConnection).setPool(this);
        this.registry.put(iConnectionPolicy.getConnectionId(), (IPort)iConnection);
        this.references.put(iConnection, 1);
        this.porter.wakeup(iConnection);
        if (bl) {
            ((TCPPort)iConnection).start();
        }
        return iConnection;
    }

    @Override
    public synchronized IConnection newTCPSocks5Connection(IConnectionPolicy iConnectionPolicy, InetSocketAddress inetSocketAddress, boolean bl) {
        IConnection iConnection;
        if (this.hasConnection(iConnectionPolicy.getConnectionId())) {
            iConnection = this.getConnection(iConnectionPolicy.getConnectionId());
            this.increaseReference(iConnection);
        }
        try {
            iConnection = new TCPSocks5Port(iConnectionPolicy, inetSocketAddress);
        }
        catch (IOException iOException) {
            return null;
        }
        ((AbstractPort)iConnection).setPool(this);
        this.registry.put(iConnectionPolicy.getConnectionId(), (IPort)iConnection);
        this.references.put(iConnection, 1);
        this.porter.wakeup(iConnection);
        if (bl) {
            ((TCPSocks5Port)iConnection).start();
        }
        return iConnection;
    }

    @Override
    public synchronized IConnection newTCPHttpConnection(IConnectionPolicy iConnectionPolicy, InetSocketAddress inetSocketAddress, boolean bl) {
        IConnection iConnection;
        if (this.hasConnection(iConnectionPolicy.getConnectionId())) {
            iConnection = this.getConnection(iConnectionPolicy.getConnectionId());
            this.increaseReference(iConnection);
        }
        try {
            iConnection = new TCPHttpPort(iConnectionPolicy, inetSocketAddress);
        }
        catch (IOException iOException) {
            return null;
        }
        ((AbstractPort)iConnection).setPool(this);
        this.registry.put(iConnectionPolicy.getConnectionId(), (IPort)iConnection);
        this.references.put(iConnection, 1);
        this.porter.wakeup(iConnection);
        if (bl) {
            ((TCPHttpPort)iConnection).start();
        }
        return iConnection;
    }

    @Override
    public synchronized void dispose() {
        new Thread(){

            public void run() {
                PortGate.this.porter.shutdown();
                PortGate.this.registry.clear();
                PortGate.this.references.clear();
                PortGate.this.porter = null;
                PortGate.this.registry = null;
                PortGate.this.references = null;
            }
        }.start();
    }

    @Override
    public void flush() {
        this.porter.wakeup();
    }

    public Porter getPorter() {
        return this.porter;
    }

    @Override
    public boolean verifyProxy(IProxyHandler iProxyHandler, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, boolean bl, String string2, String string3) {
        ProxyVerifier proxyVerifier = null;
        try {
            proxyVerifier = new ProxyVerifier(iProxyHandler, inetSocketAddress, inetSocketAddress2, string, bl, string2, string3);
            proxyVerifier.start();
            return true;
        }
        catch (IOException iOException) {
            if (proxyVerifier != null) {
                proxyVerifier.dispose();
            }
            return false;
        }
    }
}

