/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.AbstractCommand;
import f00f.net.irc.martyr.util.FullNick;
import org.apache.log4j.Logger;

public class KickCommand
extends AbstractCommand {
    static Logger log = Logger.getLogger(KickCommand.class);
    private String channel;
    private FullNick userKicker;
    private FullNick userKicked;
    private String comment;

    public KickCommand() {
        this(null, null, null, null);
    }

    public KickCommand(FullNick userKicker, String channel, String userKicked, String comment) {
        this.userKicker = userKicker;
        this.channel = channel;
        this.userKicked = new FullNick(userKicked);
        this.comment = comment;
    }

    public KickCommand(String channel, String userToKick, String comment) {
        this(null, channel, userToKick, comment);
    }

    public InCommand parse(String prefix, String identifier, String params) {
        return new KickCommand(new FullNick(prefix), this.getParameter(params, 0), this.getParameter(params, 1), this.getParameter(params, 2));
    }

    public String getIrcIdentifier() {
        return "KICK";
    }

    public String renderParams() {
        return this.channel + " " + this.userKicked + " :" + this.comment;
    }

    public String getChannel() {
        return this.channel;
    }

    public FullNick getKicker() {
        return this.userKicker;
    }

    public FullNick getKicked() {
        return this.userKicked;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean kickedUs(ClientState state) {
        return this.userKicked.equals(state.getNick());
    }

    public boolean updateClientState(ClientState state) {
        if (this.kickedUs(state)) {
            log.debug((Object)("KICK: We've been kicked " + this.channel));
            state.removeChannel(this.channel);
            return true;
        }
        log.debug((Object)("KICK: " + this.userKicked.getNick() + " kicked " + this.channel));
        Channel channelObj = state.getChannel(this.channel);
        channelObj.removeMember(this.userKicked, (InCommand)this);
        return true;
    }
}

