/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.msnftp;

import net.sf.jml.Email;
import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnProtocol;
import net.sf.jml.protocol.msnftp.MsnftpFIL;
import net.sf.jml.protocol.msnftp.MsnftpMessage;
import net.sf.jml.protocol.msnftp.MsnftpSession;
import net.sf.jml.util.NumberUtils;

public class MsnftpUSR
extends MsnftpMessage {
    public MsnftpUSR(MsnProtocol msnProtocol) {
        super(msnProtocol);
        this.setCommand("USR");
    }

    public void setEmail(Email email) {
        this.setParam(0, email.toString());
    }

    public Email getEmail() {
        return Email.parseStr(this.getParam(0));
    }

    public void setAuthStr(int n) {
        this.setParam(1, String.valueOf(n));
    }

    public int getAuthStr() {
        return NumberUtils.stringToInt(this.getParam(1));
    }

    protected void messageReceived(MsnftpSession msnftpSession) {
        super.messageReceived(msnftpSession);
        MsnFileTransfer msnFileTransfer = msnftpSession.getFileTransfer();
        if (msnFileTransfer.isSender()) {
            if (msnFileTransfer.getContact().getEmail().equals(this.getEmail())) {
                MsnftpFIL msnftpFIL = new MsnftpFIL(this.protocol);
                msnftpFIL.setFileSize(msnFileTransfer.getFileTotalSize());
                msnftpSession.sendAsynchronousMessage(msnftpFIL);
            } else {
                msnftpSession.close();
            }
        } else {
            msnftpSession.close();
        }
    }
}

