/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.internal.networking.AbstractChannel;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.networking.nio.NioChannelReader;
import com.hazelcast.internal.networking.nio.NioChannelWriter;
import com.hazelcast.nio.IOUtil;
import java.nio.channels.SocketChannel;

public class NioChannel
extends AbstractChannel {
    private NioChannelReader reader;
    private NioChannelWriter writer;

    public NioChannel(SocketChannel socketChannel, boolean clientMode) {
        super(socketChannel, clientMode);
    }

    public void setReader(NioChannelReader reader) {
        this.reader = reader;
    }

    public void setWriter(NioChannelWriter writer) {
        this.writer = writer;
    }

    public NioChannelReader getReader() {
        return this.reader;
    }

    public NioChannelWriter getWriter() {
        return this.writer;
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (this.isClosed()) {
            return false;
        }
        this.writer.write(frame);
        return true;
    }

    @Override
    public long lastReadTimeMillis() {
        return this.reader.lastReadTimeMillis();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.writer.lastWriteTimeMillis();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    protected void onClose() {
        IOUtil.closeResource(this.reader);
        IOUtil.closeResource(this.writer);
    }

    public String toString() {
        return "NioChannel{" + this.getLocalSocketAddress() + "->" + this.getRemoteSocketAddress() + '}';
    }
}

