/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.HotRestartClusterDataRecoveryPolicy;
import com.hazelcast.util.Preconditions;
import java.io.File;

public class HotRestartPersistenceConfig {
    public static final String HOT_RESTART_BASE_DIR_DEFAULT = "hot-restart";
    public static final int DEFAULT_VALIDATION_TIMEOUT = 120;
    public static final int DEFAULT_DATA_LOAD_TIMEOUT = 900;
    public static final int DEFAULT_PARALLELISM = 1;
    private boolean enabled;
    private File baseDir = new File("hot-restart");
    private File backupDir;
    private int parallelism = 1;
    private int validationTimeoutSeconds = 120;
    private int dataLoadTimeoutSeconds = 900;
    private HotRestartClusterDataRecoveryPolicy clusterDataRecoveryPolicy = HotRestartClusterDataRecoveryPolicy.FULL_RECOVERY_ONLY;

    public boolean isEnabled() {
        return this.enabled;
    }

    public HotRestartPersistenceConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public HotRestartClusterDataRecoveryPolicy getClusterDataRecoveryPolicy() {
        return this.clusterDataRecoveryPolicy;
    }

    public HotRestartPersistenceConfig setClusterDataRecoveryPolicy(HotRestartClusterDataRecoveryPolicy clusterDataRecoveryPolicy) {
        this.clusterDataRecoveryPolicy = clusterDataRecoveryPolicy;
        return this;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public HotRestartPersistenceConfig setBaseDir(File baseDir) {
        Preconditions.checkNotNull(baseDir, "Base directory cannot be null!");
        this.baseDir = baseDir;
        return this;
    }

    public File getBackupDir() {
        return this.backupDir;
    }

    public HotRestartPersistenceConfig setBackupDir(File backupDir) {
        this.backupDir = backupDir;
        return this;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public HotRestartPersistenceConfig setParallelism(int parallelism) {
        Preconditions.checkPositive(parallelism, "Palallelism must be a positive integer");
        this.parallelism = parallelism;
        return this;
    }

    public int getValidationTimeoutSeconds() {
        return this.validationTimeoutSeconds;
    }

    public HotRestartPersistenceConfig setValidationTimeoutSeconds(int validationTimeoutSeconds) {
        Preconditions.checkPositive(validationTimeoutSeconds, "Validation timeout should be positive!");
        this.validationTimeoutSeconds = validationTimeoutSeconds;
        return this;
    }

    public int getDataLoadTimeoutSeconds() {
        return this.dataLoadTimeoutSeconds;
    }

    public HotRestartPersistenceConfig setDataLoadTimeoutSeconds(int dataLoadTimeoutSeconds) {
        Preconditions.checkPositive(dataLoadTimeoutSeconds, "Load timeout should be positive!");
        this.dataLoadTimeoutSeconds = dataLoadTimeoutSeconds;
        return this;
    }
}

