/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import javax.annotation.PostConstruct;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.SessionController;
import org.jivesoftware.openfire.plugin.rest.entity.SessionEntities;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/sessions")
public class SessionService {
    private SessionController sessionController;

    @PostConstruct
    public void init() {
        this.sessionController = SessionController.getInstance();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public SessionEntities getAllSessions() throws ServiceException {
        return this.sessionController.getAllSessions();
    }

    @GET
    @Path(value="/{username}")
    @Produces(value={"application/xml", "application/json"})
    public SessionEntities getUserSessions(@PathParam(value="username") String username) throws ServiceException {
        return this.sessionController.getUserSessions(username);
    }

    @DELETE
    @Path(value="/{username}")
    public Response kickSession(@PathParam(value="username") String username) throws ServiceException {
        this.sessionController.removeUserSessions(username);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

