/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomInvitationJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomMemberJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomInvitation;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.ContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionEvent;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionMovedEvent;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.MultiUserChat;

public class OperationSetMultiUserChatJabberImpl
extends AbstractOperationSetMultiUserChat
implements SubscriptionListener {
    private static final Logger logger = Logger.getLogger(OperationSetMultiUserChatJabberImpl.class);
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private final Hashtable<String, ChatRoom> chatRoomCache = new Hashtable();
    private final RegistrationStateListener providerRegListener = new RegistrationStateListener();
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;

    OperationSetMultiUserChatJabberImpl(ProtocolProviderServiceJabberImpl jabberProvider) {
        this.jabberProvider = jabberProvider;
        jabberProvider.addRegistrationStateChangeListener(this.providerRegListener);
        this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)jabberProvider.getOperationSet(OperationSetPersistentPresence.class);
        this.opSetPersPresence.addSubscriptionListener(this);
    }

    public void addSmackInvitationRejectionListener(MultiUserChat muc, ChatRoom chatRoom) {
        muc.addInvitationRejectionListener((InvitationRejectionListener)new SmackInvitationRejectionListener(chatRoom));
    }

    public ChatRoom createChatRoom(String roomName, Map<String, Object> roomProperties) throws OperationFailedException, OperationNotSupportedException {
        this.assertSupportedAndConnected();
        ChatRoom room = null;
        if (roomName == null) {
            roomName = "chatroom-" + StringUtils.randomString((int)4);
        } else {
            room = this.findRoom(roomName);
        }
        if (room == null) {
            Object isPrivateObject;
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Find room returns null.");
            }
            if (this.getXmppConnection().getHost().toLowerCase().contains("google")) {
                roomName = "private-chat-" + UUID.randomUUID().toString() + "@groupchat.google.com";
            }
            MultiUserChat muc = null;
            try {
                muc = new MultiUserChat((Connection)this.getXmppConnection(), this.getCanonicalRoomName(roomName));
                muc.create(StringUtils.parseName((String)this.getXmppConnection().getUser()));
            }
            catch (XMPPException ex) {
                logger.error((Object)"Failed to create chat room.", (Throwable)ex);
                throw new OperationFailedException("Failed to create chat room", ex.getXMPPError().getCode(), ex.getCause());
            }
            boolean isPrivate = false;
            if (roomProperties != null && (isPrivateObject = roomProperties.get("isPrivate")) != null) {
                isPrivate = isPrivateObject.equals(true);
            }
            try {
                Form form;
                if (isPrivate) {
                    Form initForm = muc.getConfigurationForm();
                    form = initForm.createAnswerForm();
                    Iterator fieldIterator = initForm.getFields();
                    while (fieldIterator.hasNext()) {
                        FormField submitField;
                        FormField initField = (FormField)fieldIterator.next();
                        if (initField == null || initField.getVariable() == null || initField.getType() == "fixed" || initField.getType() == "hidden" || (submitField = form.getField(initField.getVariable())) == null) continue;
                        Iterator value = initField.getValues();
                        while (value.hasNext()) {
                            submitField.addValue((String)value.next());
                        }
                    }
                    String[] fields = new String[]{"muc#roomconfig_membersonly", "muc#roomconfig_allowinvites", "muc#roomconfig_publicroom"};
                    Boolean[] values = new Boolean[]{true, true, false};
                    for (int i = 0; i < fields.length; ++i) {
                        FormField field = new FormField(fields[i]);
                        field.setType("boolean");
                        form.addField(field);
                        form.setAnswer(fields[i], values[i].booleanValue());
                    }
                } else {
                    form = new Form("submit");
                }
                muc.sendConfigurationForm(form);
            }
            catch (XMPPException e) {
                logger.error((Object)"Failed to send config form.", (Throwable)e);
            }
            room = this.createLocalChatRoomInstance(muc);
            room.setLocalUserRole(ChatRoomMemberRole.OWNER);
        }
        return room;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatRoom createLocalChatRoomInstance(MultiUserChat muc) {
        Hashtable<String, ChatRoom> hashtable = this.chatRoomCache;
        synchronized (hashtable) {
            ChatRoomJabberImpl chatRoom = new ChatRoomJabberImpl(muc, this.jabberProvider);
            this.cacheChatRoom((ChatRoom)chatRoom);
            this.addSmackInvitationRejectionListener(muc, (ChatRoom)chatRoom);
            return chatRoom;
        }
    }

    public synchronized ChatRoom findRoom(String roomName) throws OperationFailedException, OperationNotSupportedException {
        this.assertSupportedAndConnected();
        String canonicalRoomName = this.getCanonicalRoomName(roomName);
        Object room = this.chatRoomCache.get(canonicalRoomName);
        if (room != null) {
            return room;
        }
        MultiUserChat muc = new MultiUserChat((Connection)this.getXmppConnection(), canonicalRoomName);
        room = new ChatRoomJabberImpl(muc, this.jabberProvider);
        this.chatRoomCache.put(canonicalRoomName, (ChatRoom)room);
        return room;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatRoom> getCurrentlyJoinedChatRooms() {
        Hashtable<String, ChatRoom> hashtable = this.chatRoomCache;
        synchronized (hashtable) {
            LinkedList<ChatRoom> joinedRooms = new LinkedList<ChatRoom>(this.chatRoomCache.values());
            Iterator joinedRoomsIter = joinedRooms.iterator();
            while (joinedRoomsIter.hasNext()) {
                if (((ChatRoom)joinedRoomsIter.next()).isJoined()) continue;
                joinedRoomsIter.remove();
            }
            return joinedRooms;
        }
    }

    public List<String> getExistingChatRooms() throws OperationFailedException, OperationNotSupportedException {
        this.assertSupportedAndConnected();
        LinkedList<String> list = new LinkedList<String>();
        Iterator serviceNames = null;
        try {
            serviceNames = MultiUserChat.getServiceNames((Connection)this.getXmppConnection()).iterator();
        }
        catch (XMPPException ex) {
            throw new OperationFailedException("Failed to retrieve Jabber conference service names", 1, (Throwable)ex);
        }
        while (serviceNames.hasNext()) {
            String serviceName = (String)serviceNames.next();
            LinkedList roomsOnThisService = new LinkedList();
            try {
                roomsOnThisService.addAll(MultiUserChat.getHostedRooms((Connection)this.getXmppConnection(), (String)serviceName));
            }
            catch (XMPPException ex) {
                logger.error((Object)("Failed to retrieve rooms for serviceName=" + serviceName), (Throwable)ex);
                continue;
            }
            Iterator serviceRoomsIter = roomsOnThisService.iterator();
            while (serviceRoomsIter.hasNext()) {
                list.add(((HostedRoom)serviceRoomsIter.next()).getJid());
            }
        }
        return list;
    }

    public boolean isMultiChatSupportedByContact(Contact contact) {
        return contact.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class) != null;
    }

    public boolean isPrivateMessagingContact(String contactAddress) {
        return this.opSetPersPresence.isPrivateMessagingContact(contactAddress);
    }

    public void rejectInvitation(ChatRoomInvitation invitation, String rejectReason) {
        MultiUserChat.decline((Connection)this.jabberProvider.getConnection(), (String)invitation.getTargetChatRoom().getName(), (String)invitation.getInviter(), (String)rejectReason);
    }

    private XMPPConnection getXmppConnection() {
        return this.jabberProvider == null ? null : this.jabberProvider.getConnection();
    }

    private void assertSupportedAndConnected() throws OperationFailedException, OperationNotSupportedException {
        if (!this.jabberProvider.isRegistered() || !this.getXmppConnection().isConnected()) {
            throw new OperationFailedException("Provider not connected to jabber server", 2);
        }
    }

    private String getCanonicalRoomName(String roomName) throws OperationFailedException {
        if (roomName.indexOf(64) > 0) {
            return roomName;
        }
        Iterator serviceNamesIter = null;
        try {
            serviceNamesIter = MultiUserChat.getServiceNames((Connection)this.getXmppConnection()).iterator();
        }
        catch (XMPPException ex) {
            logger.error((Object)("Failed to retrieve conference service name for user: " + this.jabberProvider.getAccountID().getUserID() + " on server: " + this.jabberProvider.getAccountID().getService()), (Throwable)ex);
            throw new OperationFailedException("Failed to retrieve conference service name for user: " + this.jabberProvider.getAccountID().getUserID() + " on server: " + this.jabberProvider.getAccountID().getService(), 1, (Throwable)ex);
        }
        if (serviceNamesIter.hasNext()) {
            return roomName + "@" + (String)serviceNamesIter.next();
        }
        throw new OperationFailedException("Failed to retrieve MultiUserChat service names.", 1);
    }

    private void cacheChatRoom(ChatRoom chatRoom) {
        this.chatRoomCache.put(chatRoom.getName(), chatRoom);
    }

    public ChatRoomJabberImpl getChatRoom(String chatRoomName) {
        return (ChatRoomJabberImpl)this.chatRoomCache.get(chatRoomName);
    }

    public List<String> getCurrentlyJoinedChatRooms(ChatRoomMember chatRoomMember) throws OperationFailedException, OperationNotSupportedException {
        this.assertSupportedAndConnected();
        Iterator joinedRoomsIter = MultiUserChat.getJoinedRooms((Connection)this.getXmppConnection(), (String)chatRoomMember.getContactAddress());
        ArrayList<String> joinedRooms = new ArrayList<String>();
        while (joinedRoomsIter.hasNext()) {
            joinedRooms.add((String)joinedRoomsIter.next());
        }
        return joinedRooms;
    }

    public void fireInvitationEvent(ChatRoom targetChatRoom, String inviter, String reason, byte[] password) {
        ChatRoomInvitationJabberImpl invitation = new ChatRoomInvitationJabberImpl(targetChatRoom, inviter, reason, password);
        this.fireInvitationReceived(invitation);
    }

    public void contactModified(ContactPropertyChangeEvent evt) {
        Contact modifiedContact = evt.getSourceContact();
        this.updateChatRoomMembers(modifiedContact);
    }

    public void subscriptionCreated(SubscriptionEvent evt) {
        Contact createdContact = evt.getSourceContact();
        this.updateChatRoomMembers(createdContact);
    }

    public void subscriptionFailed(SubscriptionEvent evt) {
    }

    public void subscriptionMoved(SubscriptionMovedEvent evt) {
    }

    public void subscriptionRemoved(SubscriptionEvent evt) {
    }

    public void subscriptionResolved(SubscriptionEvent evt) {
    }

    private void updateChatRoomMembers(Contact contact) {
        Enumeration<ChatRoom> chatRooms = this.chatRoomCache.elements();
        while (chatRooms.hasMoreElements()) {
            ChatRoomJabberImpl chatRoom = (ChatRoomJabberImpl)chatRooms.nextElement();
            ChatRoomMemberJabberImpl member = chatRoom.findMemberForNickName(contact.getAddress());
            if (member == null) continue;
            member.setContact(contact);
            member.setAvatar(contact.getImage());
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"adding an Invitation listener to the smack muc");
                }
                MultiUserChat.addInvitationListener((Connection)OperationSetMultiUserChatJabberImpl.this.jabberProvider.getConnection(), (InvitationListener)new SmackInvitationListener());
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                OperationSetMultiUserChatJabberImpl.this.chatRoomCache.clear();
            } else if (evt.getNewState() == RegistrationState.UNREGISTERING) {
                List<ChatRoom> joinedRooms = OperationSetMultiUserChatJabberImpl.this.getCurrentlyJoinedChatRooms();
                for (ChatRoom room : joinedRooms) {
                    room.leave();
                }
            }
        }
    }

    private class SmackInvitationRejectionListener
    implements InvitationRejectionListener {
        private ChatRoom chatRoom;

        public SmackInvitationRejectionListener(ChatRoom chatRoom) {
            this.chatRoom = chatRoom;
        }

        public void invitationDeclined(String invitee, String reason) {
            OperationSetMultiUserChatJabberImpl.this.fireInvitationRejectedEvent(this.chatRoom, invitee, reason);
        }
    }

    private class SmackInvitationListener
    implements InvitationListener {
        private SmackInvitationListener() {
        }

        public void invitationReceived(Connection conn, String room, String inviter, String reason, String password, Message message) {
            try {
                ChatRoomJabberImpl chatRoom = (ChatRoomJabberImpl)OperationSetMultiUserChatJabberImpl.this.findRoom(room);
                if (password != null) {
                    OperationSetMultiUserChatJabberImpl.this.fireInvitationEvent((ChatRoom)chatRoom, inviter, reason, password.getBytes());
                } else {
                    OperationSetMultiUserChatJabberImpl.this.fireInvitationEvent((ChatRoom)chatRoom, inviter, reason, null);
                }
            }
            catch (OperationFailedException e) {
                logger.error((Object)("Failed to find room with name: " + room), (Throwable)e);
            }
            catch (OperationNotSupportedException e) {
                logger.error((Object)("Failed to find room with name: " + room), (Throwable)e);
            }
        }
    }
}

