/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class RecordReplicationInfo
implements DataSerializable {
    private Data key;
    private Data value;
    private RecordStatistics statistics;
    private long idleDelayMillis = -1L;
    private long ttlDelayMillis = -1L;
    private long mapStoreWriteDelayMillis = -1L;
    private long mapStoreDeleteDelayMillis = -1L;

    public RecordReplicationInfo(Data key, Data value, RecordStatistics statistics, long idleDelayMillis, long ttlDelayMillis, long mapStoreWriteDelayMillis, long mapStoreDeleteDelayMillis) {
        this.key = key;
        this.value = value;
        this.statistics = statistics;
        this.idleDelayMillis = idleDelayMillis;
        this.ttlDelayMillis = ttlDelayMillis;
        this.mapStoreWriteDelayMillis = mapStoreWriteDelayMillis;
        this.mapStoreDeleteDelayMillis = mapStoreDeleteDelayMillis;
    }

    public RecordReplicationInfo(Data key, Data value, RecordStatistics statistics) {
        this.key = key;
        this.value = value;
        this.statistics = statistics;
    }

    public RecordReplicationInfo() {
    }

    public Data getKey() {
        return this.key;
    }

    public Data getValue() {
        return this.value;
    }

    public RecordStatistics getStatistics() {
        return this.statistics;
    }

    public long getIdleDelayMillis() {
        return this.idleDelayMillis;
    }

    public long getTtlDelayMillis() {
        return this.ttlDelayMillis;
    }

    public long getMapStoreWriteDelayMillis() {
        return this.mapStoreWriteDelayMillis;
    }

    public long getMapStoreDeleteDelayMillis() {
        return this.mapStoreDeleteDelayMillis;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.key.writeData(out);
        this.value.writeData(out);
        if (this.statistics != null) {
            out.writeBoolean(true);
            this.statistics.writeData(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.idleDelayMillis);
        out.writeLong(this.ttlDelayMillis);
        out.writeLong(this.mapStoreWriteDelayMillis);
        out.writeLong(this.mapStoreDeleteDelayMillis);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = new Data();
        this.key.readData(in);
        this.value = new Data();
        this.value.readData(in);
        boolean statsEnabled = in.readBoolean();
        if (statsEnabled) {
            this.statistics = new RecordStatistics();
            this.statistics.readData(in);
        }
        this.idleDelayMillis = in.readLong();
        this.ttlDelayMillis = in.readLong();
        this.mapStoreWriteDelayMillis = in.readLong();
        this.mapStoreDeleteDelayMillis = in.readLong();
    }
}

