/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.beans;

import java.nio.ByteBuffer;
import net.sf.jqql.Util;

public class FontStyle {
    private static final byte NONE = 0;
    private static final byte BOLD = 32;
    private static final byte ITALIC = 64;
    private static final byte UNDERLINE = -128;
    private int red = 0;
    private int green = 0;
    private int blue = 0;
    private String fontName = "\u5b8b\u4f53";
    private boolean bold = false;
    private boolean italic = false;
    private boolean underline = false;
    private int fontSize = 9;
    private char fontFlag;
    private String encoding = "GBK";
    private char encodingCode = (char)34306;

    public FontStyle() {
        this.fontFlag = (char)9;
    }

    public void writeBean(ByteBuffer byteBuffer) {
        byteBuffer.putChar(this.fontFlag);
        byteBuffer.put((byte)this.red);
        byteBuffer.put((byte)this.green);
        byteBuffer.put((byte)this.blue);
        byteBuffer.put((byte)0);
        byteBuffer.putChar(this.encodingCode);
        byte[] byArray = Util.getBytes(this.fontName);
        byteBuffer.put(byArray);
        byteBuffer.put((byte)(byArray.length + 9 & 0xFF));
    }

    public void readBean(ByteBuffer byteBuffer) {
        this.fontFlag = byteBuffer.getChar();
        this.fontSize = this.fontFlag & 0x1F;
        this.bold = (this.fontFlag & 0x20) != 0;
        this.italic = (this.fontFlag & 0x40) != 0;
        this.underline = (this.fontFlag & 0x80) != 0;
        this.red = byteBuffer.get() & 0xFF;
        this.green = byteBuffer.get() & 0xFF;
        this.blue = byteBuffer.get() & 0xFF;
        byteBuffer.get();
        this.encodingCode = byteBuffer.getChar();
        this.encoding = Util.getEncodingString(this.encodingCode);
        this.fontName = Util.getString(byteBuffer, byteBuffer.remaining() - 1);
        this.checkFontSize();
    }

    private void checkFontSize() {
        int n = this.fontFlag & 0xFF;
        if (n > 24) {
            n = 24;
        }
        this.fontFlag = (char)224;
        this.fontFlag = (char)(this.fontFlag | n);
    }

    public int getBlue() {
        return this.blue;
    }

    public void setBlue(int n) {
        this.blue = n;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bl) {
        this.bold = bl;
        this.fontFlag = (char)(this.fontFlag & 0xDF);
        this.fontFlag = (char)(this.fontFlag | (bl ? 32 : 0));
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public int getGreen() {
        return this.green;
    }

    public void setGreen(int n) {
        this.green = n;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean bl) {
        this.italic = bl;
        this.fontFlag = (char)(this.fontFlag & 0xBF);
        this.fontFlag = (char)(this.fontFlag | (bl ? 64 : 0));
    }

    public int getRed() {
        return this.red;
    }

    public void setRed(int n) {
        this.red = n;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean bl) {
        this.underline = bl;
        this.fontFlag = (char)(this.fontFlag & 0x7F);
        this.fontFlag = (char)(this.fontFlag | (bl ? -128 : 0));
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.fontFlag = (char)(this.fontFlag & 0xE0);
        this.fontFlag = (char)(this.fontFlag | (n &= 0x1F));
    }

    public char getEncodingCode() {
        return this.encodingCode;
    }

    public void setEncodingCode(char c) {
        this.encodingCode = c;
    }
}

