/*
 * Decompiled with CFR 0.152.
 */
package ymsg.support;

import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import ymsg.support.AltEnumeration;
import ymsg.support.Emoticons;
import ymsg.support.FadeEnumeration;
import ymsg.support.MessageDecoderSettings;

public class MessageElement
implements Emoticons {
    public static final int NULL = -2;
    public static final int ROOT = -1;
    public static final int TEXT = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int COLOUR_INDEX = 3;
    public static final int UNDERLINE = 4;
    public static final int FONT = 5;
    public static final int FADE = 6;
    public static final int ALT = 7;
    public static final int COLOUR_ABS = 8;
    public static final int COLOUR_NAME = 9;
    protected int type;
    protected Vector children;
    protected int fontSize;
    protected String fontFace;
    protected String text;
    protected Color[] transition;
    protected Color colour;
    private MessageDecoderSettings settings;
    protected static final String[] COLOUR_INDEXES = new String[]{"black", "blue", "cyan", "pink", "green", "gray", "purple", "orange", "red", "brown", "yellow"};
    protected static final Color[] COLOUR_OBJECTS = new Color[]{Color.black, Color.blue, Color.cyan, Color.pink, Color.green, Color.gray, Color.magenta, Color.orange, Color.red, Color.lightGray, Color.yellow};
    private static final String TAB = "  ";
    static Icon[] emoticonCache = new Icon[Emoticons.EMOTICONS.length];
    static StyleContext styleContext;

    protected MessageElement(MessageDecoderSettings messageDecoderSettings, int n) {
        this.settings = messageDecoderSettings;
        this.type = n;
        this.children = new Vector();
    }

    protected MessageElement(MessageDecoderSettings messageDecoderSettings, int n, String string) {
        this(messageDecoderSettings, n);
        switch (n) {
            case 0: {
                this.text = string;
                break;
            }
            case 5: {
                this.fontFace = this._attr(string, "face");
                String string2 = this._attr(string, "size");
                if (string2 != null) {
                    try {
                        this.fontSize = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.fontFace == null) {
                    this.type = -2;
                }
                if (this.settings == null) break;
                if (this.settings.overMaxFontSize >= 0 && this.fontSize > this.settings.overMaxFontSize) {
                    this.fontSize = this.settings.overMaxFontSize;
                }
                if (this.settings.overMinFontSize >= 0 && this.fontSize < this.settings.overMinFontSize) {
                    this.fontSize = this.settings.overMinFontSize;
                }
                if (this.settings.overFontFace == null) break;
                this.fontFace = this.settings.overFontFace;
                break;
            }
            case 6: 
            case 7: {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                this.transition = new Color[stringTokenizer.countTokens()];
                int n2 = 0;
                while (stringTokenizer.countTokens() > 0) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("#")) {
                        string3 = string3.substring(1);
                    }
                    try {
                        this.transition[n2++] = new Color(Integer.parseInt(string3, 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.transition[n2 - 1] = Color.black;
                    }
                }
                break;
            }
            case 3: {
                this.colour = COLOUR_OBJECTS[string.charAt(0) - 48];
                if (this.settings == null || this.settings.overFg == null) break;
                this.colour = this.settings.overFg;
                break;
            }
            case 8: {
                this.colour = new Color(Integer.parseInt(string, 16));
                if (this.settings == null || this.settings.overFg == null) break;
                this.colour = this.settings.overFg;
            }
        }
    }

    protected MessageElement(MessageDecoderSettings messageDecoderSettings, int n, int n2) {
        this(messageDecoderSettings, n);
        switch (n) {
            case 9: {
                this.colour = COLOUR_OBJECTS[n2];
                if (this.settings == null || this.settings.overFg == null) break;
                this.colour = this.settings.overFg;
            }
        }
    }

    private String _attr(String string, String string2) {
        string2 = string2 + "=\"";
        String string3 = string.toLowerCase();
        int n = string3.indexOf(string2);
        if (n >= 0) {
            if ((n = (string = string.substring(n + string2.length())).indexOf("\"")) >= 0) {
                string = string.substring(0, n);
            }
            return string;
        }
        return null;
    }

    static int whichColourName(String string) {
        for (int i = 0; i < COLOUR_INDEXES.length; ++i) {
            if (!string.equals(COLOUR_INDEXES[i])) continue;
            return i;
        }
        return -1;
    }

    boolean colourEquals(int n) {
        return this.colour == COLOUR_OBJECTS[n];
    }

    int childTextSize() {
        int n = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            MessageElement messageElement = (MessageElement)this.children.elementAt(i);
            if (messageElement.type == 0) {
                n += messageElement.text.length();
                continue;
            }
            n += messageElement.childTextSize();
        }
        return n;
    }

    void addChild(MessageElement messageElement) {
        this.children.addElement(messageElement);
    }

    public String toHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toHTML(stringBuffer);
        return stringBuffer.toString();
    }

    private void toHTML(StringBuffer stringBuffer) {
        switch (this.type) {
            case -2: {
                stringBuffer.append("<span>");
                break;
            }
            case 0: {
                stringBuffer.append(this.text);
                break;
            }
            case 1: {
                stringBuffer.append("<b>");
                break;
            }
            case 2: {
                stringBuffer.append("<i>");
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                stringBuffer.append("<font color=\"#").append("" + this.colour.getRGB()).append("\">");
                break;
            }
            case 4: {
                stringBuffer.append("<u>");
                break;
            }
            case 5: {
                stringBuffer.append("<font face=\"" + this.fontFace + "\" size=\"" + this.fontSize + "\">");
                break;
            }
            case 6: {
                stringBuffer.append("<span>");
                break;
            }
            case 7: {
                stringBuffer.append("<span>");
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            MessageElement messageElement = (MessageElement)this.children.elementAt(i);
            messageElement.toHTML(stringBuffer);
        }
        switch (this.type) {
            case -2: {
                stringBuffer.append("</span>");
                break;
            }
            case 1: {
                stringBuffer.append("</b>");
                break;
            }
            case 2: {
                stringBuffer.append("</i>");
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                stringBuffer.append("</font>");
                break;
            }
            case 4: {
                stringBuffer.append("</u>");
                break;
            }
            case 5: {
                stringBuffer.append("</font>");
                break;
            }
            case 6: {
                stringBuffer.append("</span>");
                break;
            }
            case 7: {
                stringBuffer.append("</span>");
            }
        }
    }

    public String toText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toText(stringBuffer);
        return stringBuffer.toString();
    }

    private void toText(StringBuffer stringBuffer) {
        if (this.type == 0) {
            stringBuffer.append(this.text);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            MessageElement messageElement = (MessageElement)this.children.elementAt(i);
            messageElement.toText(stringBuffer);
        }
    }

    public void appendToDocument(Document document) {
        try {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            if (this.settings != null) {
                if (this.settings.defFontFace != null) {
                    StyleConstants.setFontFamily(simpleAttributeSet, this.settings.defFontFace);
                }
                if (this.settings.defFontSize >= 0) {
                    StyleConstants.setFontSize(simpleAttributeSet, this.settings.defFontSize);
                }
            }
            if (styleContext == null) {
                styleContext = StyleContext.getDefaultStyleContext();
            }
            this.appendToDocument(document, simpleAttributeSet, new LocalSettings());
            document.insertString(document.getLength(), "\n", simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void appendToDocument(Document document, AttributeSet attributeSet, LocalSettings localSettings) throws BadLocationException {
        AttributeSet attributeSet2 = new SimpleAttributeSet(attributeSet);
        switch (this.type) {
            case 0: {
                if (this.settings != null && !this.settings.emoticonsOn) {
                    this._textWithoutIcons(document, this.text, attributeSet2, localSettings);
                    break;
                }
                this._textWithIcons(document, this.text, attributeSet2, localSettings);
                break;
            }
            case 1: {
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.Bold, Boolean.TRUE);
                break;
            }
            case 2: {
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.Italic, Boolean.TRUE);
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.Foreground, this.colour);
                break;
            }
            case 4: {
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.Underline, Boolean.TRUE);
                break;
            }
            case 5: {
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.FontFamily, this.fontFace);
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.FontSize, new Integer(this.fontSize));
                break;
            }
            case 6: {
                if (this.settings == null || !this.settings.respectFade) break;
                localSettings.colourTransition = new FadeEnumeration(this.transition, this.childTextSize());
                break;
            }
            case 7: {
                if (this.settings == null || !this.settings.respectAlt) break;
                localSettings.colourTransition = new AltEnumeration(this.transition);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            MessageElement messageElement = (MessageElement)this.children.elementAt(i);
            messageElement.appendToDocument(document, attributeSet2, localSettings);
        }
        switch (this.type) {
            case 1: {
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.Bold, Boolean.FALSE);
                break;
            }
            case 2: {
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.Italic, Boolean.FALSE);
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.Foreground, styleContext.getForeground(attributeSet));
                break;
            }
            case 4: {
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.Underline, Boolean.FALSE);
                break;
            }
            case 5: {
                Font font = styleContext.getFont(attributeSet);
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.FontFamily, font.getFamily());
                attributeSet2 = styleContext.addAttribute(attributeSet2, StyleConstants.FontSize, new Integer(font.getSize()));
                break;
            }
            case 6: 
            case 7: {
                localSettings.colourTransition = null;
            }
        }
    }

    private void _textWithIcons(Document document, String string, AttributeSet attributeSet, LocalSettings localSettings) throws BadLocationException {
        int n;
        do {
            int n2;
            int n3 = string.length();
            n = -1;
            int n4 = -1;
            for (int i = 0; i < Emoticons.EMOTICONS.length; ++i) {
                for (n2 = 0; n2 < Emoticons.EMOTICONS[i].length; ++n2) {
                    int n5 = string.indexOf(Emoticons.EMOTICONS[i][n2]);
                    if (n5 < 0 || n5 >= n3 && (n < 0 || n5 != n3 || Emoticons.EMOTICONS[i][n2].length() <= Emoticons.EMOTICONS[n4][n].length())) continue;
                    n3 = n5;
                    n4 = i;
                    n = n2;
                }
            }
            if (n < 0) continue;
            this._textWithoutIcons(document, string.substring(0, n3), attributeSet, localSettings);
            if (emoticonCache[n4] == null) {
                MessageElement.emoticonCache[n4] = this.settings != null ? this.settings.getEmoticon(n4) : new ImageIcon(this.getClass().getResource(n4 + ".gif"));
            }
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setIcon(simpleAttributeSet, emoticonCache[n4]);
            document.insertString(document.getLength(), Emoticons.EMOTICONS[n4][n], simpleAttributeSet);
            if (localSettings.colourTransition != null) {
                for (n2 = 0; n2 < Emoticons.EMOTICONS[n4][n].length(); ++n2) {
                    localSettings.colourTransition.nextElement();
                }
            }
            string = string.substring(n3 + Emoticons.EMOTICONS[n4][n].length());
        } while (string.length() > 0 && n >= 0);
        if (string.length() > 0) {
            this._textWithoutIcons(document, string, attributeSet, localSettings);
        }
    }

    private void _textWithoutIcons(Document document, String string, AttributeSet attributeSet, LocalSettings localSettings) throws BadLocationException {
        if (localSettings.colourTransition != null) {
            for (int i = 0; i < string.length(); ++i) {
                attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.Foreground, (Color)localSettings.colourTransition.nextElement());
                document.insertString(document.getLength(), "" + string.charAt(i), attributeSet);
            }
        } else {
            document.insertString(document.getLength(), string, attributeSet);
        }
    }

    String toTree() {
        return this.toTree(TAB);
    }

    String toTree(String string) {
        String string2 = this.toString() + "\n";
        for (int i = 0; i < this.children.size(); ++i) {
            MessageElement messageElement = (MessageElement)this.children.elementAt(i);
            string2 = string2 + string + messageElement.toTree(string + TAB);
        }
        return string2;
    }

    public String toString() {
        switch (this.type) {
            case -2: {
                return "[Null]";
            }
            case -1: {
                return "[Root]";
            }
            case 0: {
                return "Text:" + this.text;
            }
            case 1: {
                return "<b>";
            }
            case 2: {
                return "<i>";
            }
            case 3: {
                return "<col @" + this.colour + ">";
            }
            case 4: {
                return "<u>";
            }
            case 5: {
                return "<font " + this.fontFace + ":" + this.fontSize + ">";
            }
            case 6: {
                return "<fade " + this.transition + ">";
            }
            case 7: {
                return "<alt " + this.transition + ">";
            }
            case 8: {
                return "<col #" + this.colour + ">";
            }
            case 9: {
                return "<col name #" + this.colour + ">";
            }
        }
        return "?";
    }

    class LocalSettings {
        Enumeration colourTransition;

        LocalSettings() {
        }
    }
}

