/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

public class YahooUser {
    protected String id;
    protected long status;
    protected boolean onChat;
    protected boolean onPager;
    protected boolean ignored;
    protected String customStatusMessage;
    protected boolean customStatusBusy;
    private int groupCount = 0;

    YahooUser(String i, long st, boolean ch, boolean pg) {
        this.update(i, st, ch, pg);
    }

    YahooUser(String i, String st, String ch, String pg) {
        this.update(i, st, ch, pg);
    }

    YahooUser(String i) {
        this(i, 0x5A55AA56L, false, false);
    }

    void setIgnored(boolean i) {
        this.ignored = i;
    }

    void setCustom(String m, String a) {
        this.customStatusMessage = m;
        this.customStatusBusy = a.charAt(0) == '1';
    }

    void adjustGroupCount(int inc) {
        this.groupCount += inc;
    }

    public String getId() {
        return this.id;
    }

    public long getStatus() {
        return this.status;
    }

    public boolean isOnChat() {
        return this.onChat;
    }

    public boolean isOnPager() {
        return this.onPager;
    }

    public boolean isLoggedIn() {
        return this.onChat || this.onPager;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public String getCustomStatusMessage() {
        return this.customStatusMessage;
    }

    public boolean isCustomBusy() {
        return this.customStatusBusy;
    }

    public boolean isFriend() {
        return this.groupCount > 0;
    }

    public String toString() {
        return "id=" + this.id + " status=0x" + Long.toHexString(this.status) + " chat?=" + this.onChat + " pager?=" + this.onPager + " ignored?=" + this.ignored + " custMesg=" + this.customStatusMessage + " custBusy?=" + this.customStatusBusy + " friend?=" + this.isFriend();
    }

    void update(String i, String st, String vs) {
        int visibility = 0;
        visibility = vs == null ? 0 : Integer.parseInt(vs);
        this.update(i, Long.parseLong(st), (visibility & 2) > 0, (visibility & 1) > 0);
    }

    void update(String i, String st, String ch, String pg) {
        this.update(i, Long.parseLong(st), ch != null && ch.charAt(0) == '1', pg != null && pg.charAt(0) == '1');
    }

    void update(String i, long st, boolean ch, boolean pg) {
        this.id = i;
        this.status = st;
        this.onChat = ch;
        this.onPager = pg;
        if (this.status != 99L) {
            this.customStatusMessage = null;
            this.customStatusBusy = false;
        }
    }
}

