/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.util.Vector;
import ymsg.network.Session;
import ymsg.network.UserStore;
import ymsg.network.YMSG9Packet;
import ymsg.network.YahooIdentity;
import ymsg.network.YahooUser;

public class YahooConference {
    protected Vector users;
    protected String room;
    private boolean closed;
    private Vector packetBuffer;
    private Session parent;
    private YahooIdentity identity;
    private UserStore userStore;

    YahooConference(UserStore us, YahooIdentity yid, String r, Session ss, boolean b) {
        this.userStore = us;
        this.identity = yid;
        this.users = new Vector();
        this.parent = ss;
        this.room = r;
        this.closed = false;
        this.packetBuffer = b ? new Vector() : null;
    }

    YahooConference(UserStore us, YahooIdentity yid, String r, Session ss) {
        this(us, yid, r, ss, true);
    }

    void closeConference() {
        this.closed = true;
    }

    public String getName() {
        return this.room;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Vector getMembers() {
        return (Vector)this.users.clone();
    }

    public YahooIdentity getIdentity() {
        return this.identity;
    }

    public String toString() {
        return "name=" + this.room + " users=" + this.users.size() + " id=" + this.identity.getId() + " closed?=" + this.closed;
    }

    boolean isInvited() {
        return this.packetBuffer == null;
    }

    Vector inviteReceived() {
        Vector v = this.packetBuffer;
        this.packetBuffer = null;
        return v;
    }

    void addPacket(YMSG9Packet ev) {
        if (this.packetBuffer == null) {
            throw new IllegalStateException("Cannot buffer packets, invite already received");
        }
        this.packetBuffer.addElement(ev);
    }

    Vector getUsers() {
        return this.users;
    }

    synchronized void addUsers(String[] u) {
        for (int i = 0; i < u.length; ++i) {
            this.addUser(u[i]);
        }
    }

    synchronized void addUser(String u) {
        if (!this.exists(u) && !this.id(u)) {
            this.users.addElement(this.userStore.getOrCreate(u));
        }
    }

    synchronized void removeUser(String u) {
        for (int i = 0; i < this.users.size(); ++i) {
            if (!this._get(i).getId().equals(u)) continue;
            this.users.removeElementAt(i);
            return;
        }
    }

    private YahooUser _get(int i) {
        return (YahooUser)this.users.elementAt(i);
    }

    private boolean exists(String s) {
        for (int i = 0; i < this.users.size(); ++i) {
            if (!this._get(i).getId().equals(s)) continue;
            return true;
        }
        return false;
    }

    private boolean id(String s) {
        YahooIdentity[] identities = this.parent.getIdentities();
        for (int i = 0; i < identities.length; ++i) {
            if (!identities[i].getId().equals(s)) continue;
            return true;
        }
        return false;
    }
}

