/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import ymsg.network.Util;

class DebugInputStream
extends FilterInputStream {
    ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);

    public DebugInputStream(InputStream is) {
        super(is);
    }

    public int read() throws IOException {
        int b = super.read();
        this.baos.write(b);
        return b;
    }

    public int read(byte[] b) throws IOException {
        int l = super.read(b);
        if (l > 0) {
            this.baos.write(b, 0, l);
        }
        return l;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int l = super.read(b, off, len);
        if (l > 0) {
            this.baos.write(b, off, l);
        }
        return l;
    }

    public void debugDump() {
        Util.dump(this.baos.toByteArray(), "\n--INPUT--");
        this.baos.reset();
    }

    public void debugReset() {
        this.baos.reset();
    }
}

