/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.tlv;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.tlv.AbstractTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class DefaultMutableTlvChain
extends AbstractTlvChain
implements MutableTlvChain {
    private final List tlvList = new LinkedList();
    private final Map tlvMap = new HashMap();

    protected DefaultMutableTlvChain() {
    }

    protected DefaultMutableTlvChain(TlvChain tlvChain) {
        this.copy(tlvChain);
    }

    public final synchronized void addTlv(Tlv tlv) {
        this.addTlvImpl(tlv);
    }

    public final synchronized void replaceTlv(Tlv tlv) {
        DefensiveTools.checkNull(tlv, "tlv");
        int n = tlv.getType();
        Integer n2 = new Integer(n);
        LinkedList<Tlv> linkedList = (LinkedList<Tlv>)this.getTlvMap().get(n2);
        int n3 = -1;
        if (linkedList == null) {
            linkedList = new LinkedList<Tlv>();
            this.getTlvMap().put(n2, linkedList);
        } else if (!linkedList.isEmpty()) {
            int n4 = 0;
            Iterator iterator = this.getTlvList().iterator();
            while (iterator.hasNext()) {
                Tlv tlv2 = (Tlv)iterator.next();
                if (tlv2.getType() == n) {
                    if (n3 == -1) {
                        n3 = n4;
                    }
                    iterator.remove();
                }
                ++n4;
            }
            linkedList.clear();
        }
        if (n3 == -1) {
            n3 = this.getTlvList().size();
        }
        linkedList.add(tlv);
        this.getTlvList().add(n3, tlv);
    }

    public final synchronized void removeTlv(Tlv tlv) {
        DefensiveTools.checkNull(tlv, "tlv");
        int n = tlv.getType();
        Integer n2 = new Integer(n);
        List list = (List)this.getTlvMap().get(n2);
        if (list != null) {
            while (list.remove(tlv)) {
            }
        }
        while (this.getTlvList().remove(tlv)) {
        }
    }

    public final synchronized void removeTlvs(int n) {
        DefensiveTools.checkRange(n, "type", 0);
        Integer n2 = new Integer(n);
        List list = (List)this.getTlvMap().remove(n2);
        if (list != null) {
            this.getTlvList().removeAll(list);
        }
    }

    public final synchronized void removeTlvs(int[] nArray) {
        int n;
        DefensiveTools.checkNull(nArray, "types");
        nArray = (int[])nArray.clone();
        for (n = 0; n < nArray.length; ++n) {
            DefensiveTools.checkRange(nArray[n], "types[] elements", 0);
        }
        for (n = 0; n < nArray.length; ++n) {
            this.removeTlvs(nArray[n]);
        }
    }

    public final synchronized void addAll(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "other");
        List<Tlv> list = tlvChain instanceof AbstractTlvChain ? ((AbstractTlvChain)tlvChain).getTlvList() : Arrays.asList(tlvChain.getTlvs());
        Iterator<Tlv> iterator = list.iterator();
        while (iterator.hasNext()) {
            Tlv tlv = iterator.next();
            this.addTlvImpl(tlv);
        }
    }

    public final synchronized void replaceAll(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "other");
        List<Tlv> list = tlvChain instanceof AbstractTlvChain ? ((AbstractTlvChain)tlvChain).getTlvList() : Arrays.asList(tlvChain.getTlvs());
        Iterator<Tlv> iterator = list.iterator();
        while (iterator.hasNext()) {
            Tlv tlv = iterator.next();
            this.replaceTlv(tlv);
        }
    }

    protected synchronized List getTlvList() {
        return this.tlvList;
    }

    protected synchronized Map getTlvMap() {
        return this.tlvMap;
    }
}

