/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.rooms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExchangeInfo;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joscar.snaccmd.rooms.RoomCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class RoomResponse
extends RoomCommand {
    private static final int TYPE_MAX_ROOMS = 2;
    private static final int TYPE_EXCHANGE_INFO = 3;
    private static final int TYPE_ROOM_INFO = 4;
    private final int maxRooms;
    private final ExchangeInfo[] exchangeInfos;
    private final FullRoomInfo roomInfo;

    protected RoomResponse(SnacPacket snacPacket) {
        super(9);
        ByteBlock byteBlock;
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock2 = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        Tlv tlv = immutableTlvChain.getLastTlv(2);
        this.maxRooms = tlv != null ? (int)BinaryTools.getUByte(tlv.getData(), 0) : -1;
        Tlv[] tlvArray = immutableTlvChain.getTlvs(3);
        LinkedList<ExchangeInfo> linkedList = new LinkedList<ExchangeInfo>();
        for (int i = 0; i < tlvArray.length; ++i) {
            byteBlock = tlvArray[i].getData();
            ExchangeInfo exchangeInfo = ExchangeInfo.readExchangeInfo(byteBlock);
            if (exchangeInfo == null) continue;
            linkedList.add(exchangeInfo);
        }
        this.exchangeInfos = linkedList.isEmpty() ? null : linkedList.toArray(new ExchangeInfo[0]);
        Tlv tlv2 = immutableTlvChain.getLastTlv(4);
        if (tlv2 != null) {
            byteBlock = tlv2.getData();
            this.roomInfo = FullRoomInfo.readRoomInfo(byteBlock);
        } else {
            this.roomInfo = null;
        }
    }

    public RoomResponse(FullRoomInfo fullRoomInfo) {
        this(-1, null, fullRoomInfo);
    }

    public RoomResponse(int n, ExchangeInfo[] exchangeInfoArray) {
        this(n, exchangeInfoArray, null);
    }

    public RoomResponse(int n, ExchangeInfo[] exchangeInfoArray, FullRoomInfo fullRoomInfo) {
        super(9);
        DefensiveTools.checkRange(n, "maxRooms", -1);
        this.maxRooms = n;
        this.exchangeInfos = (ExchangeInfo[])(exchangeInfoArray == null ? null : exchangeInfoArray.clone());
        this.roomInfo = fullRoomInfo;
    }

    public final int getMaxRooms() {
        return this.maxRooms;
    }

    public final ExchangeInfo[] getExchangeInfos() {
        return (ExchangeInfo[])(this.exchangeInfos == null ? null : this.exchangeInfos.clone());
    }

    public final FullRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.maxRooms != -1) {
            Tlv.getUShortInstance(2, this.maxRooms).write(outputStream);
        }
        if (this.exchangeInfos != null) {
            for (int i = 0; i < this.exchangeInfos.length; ++i) {
                new Tlv(3, ByteBlock.createByteBlock(this.exchangeInfos[i])).write(outputStream);
            }
        }
        if (this.roomInfo != null) {
            new Tlv(4, ByteBlock.createByteBlock(this.roomInfo)).write(outputStream);
        }
    }

    public String toString() {
        return "RoomResponse: maxRooms=" + this.maxRooms + ", exchangeInfos=" + (this.exchangeInfos == null ? -1 : this.exchangeInfos.length) + ", roomInfo=" + this.roomInfo;
    }
}

