/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.loc.LocCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class SetInterestsCmd
extends LocCommand {
    private static final int TYPE_CHARSET = 28;
    private static final int TYPE_INTEREST = 11;
    private final String[] interests;

    protected SetInterestsCmd(SnacPacket snacPacket) {
        super(15);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        String string = immutableTlvChain.getString(28);
        Tlv[] tlvArray = immutableTlvChain.getTlvs(11);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tlvArray.length; ++i) {
            ByteBlock byteBlock2 = tlvArray[i].getData();
            String string2 = OscarTools.getString(byteBlock2, string);
            arrayList.add(string2);
        }
        this.interests = arrayList.toArray(new String[0]);
    }

    public SetInterestsCmd(String[] stringArray) {
        super(15);
        this.interests = (String[])(stringArray == null ? null : stringArray.clone());
    }

    public final String[] getInterests() {
        return (String[])(this.interests == null ? null : this.interests.clone());
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.interests != null && this.interests.length > 0) {
            MinimalEncoder minimalEncoder = new MinimalEncoder();
            minimalEncoder.updateAll(this.interests);
            Tlv.getStringInstance(28, minimalEncoder.getCharset()).write(outputStream);
            for (int i = 0; i < this.interests.length; ++i) {
                byte[] byArray = minimalEncoder.encode(this.interests[i]).getData();
                new Tlv(11, ByteBlock.wrap(byArray)).write(outputStream);
            }
        }
    }

    public String toString() {
        return "SetInterestsCmd: interests=" + Arrays.asList(this.interests);
    }
}

