/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.acct.AcctCommand;
import net.kano.joscar.snaccmd.auth.AuthCommand;
import net.kano.joscar.snaccmd.buddy.BuddyCommand;
import net.kano.joscar.snaccmd.chat.ChatCommand;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.snaccmd.icon.IconCommand;
import net.kano.joscar.snaccmd.invite.InviteCommand;
import net.kano.joscar.snaccmd.loc.LocCommand;
import net.kano.joscar.snaccmd.popup.PopupCommand;
import net.kano.joscar.snaccmd.rooms.RoomCommand;
import net.kano.joscar.snaccmd.search.SearchCommand;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public final class SnacFamilyInfoFactory {
    private static final Map families = new HashMap();

    private SnacFamilyInfoFactory() {
    }

    public static SnacFamilyInfo[] getDefaultFamilyInfos(int[] nArray) {
        DefensiveTools.checkNull(nArray, "supportedFamilies");
        LinkedList<SnacFamilyInfo> linkedList = new LinkedList<SnacFamilyInfo>();
        for (int i = 0; i < nArray.length; ++i) {
            SnacFamilyInfo snacFamilyInfo = SnacFamilyInfoFactory.getFamily(nArray[i]);
            if (snacFamilyInfo == null) continue;
            linkedList.add(snacFamilyInfo);
        }
        return linkedList.toArray(new SnacFamilyInfo[0]);
    }

    private static SnacFamilyInfo getFamily(int n) {
        return (SnacFamilyInfo)families.get(new Integer(n));
    }

    static {
        List<SnacFamilyInfo> list = Arrays.asList(AuthCommand.FAMILY_INFO, ConnCommand.FAMILY_INFO, LocCommand.FAMILY_INFO, BuddyCommand.FAMILY_INFO, PopupCommand.FAMILY_INFO, AcctCommand.FAMILY_INFO, RoomCommand.FAMILY_INFO, ChatCommand.FAMILY_INFO, InviteCommand.FAMILY_INFO, SearchCommand.FAMILY_INFO, IconCommand.FAMILY_INFO, SsiCommand.FAMILY_INFO, IcbmCommand.FAMILY_INFO);
        Iterator<SnacFamilyInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            SnacFamilyInfo snacFamilyInfo = iterator.next();
            families.put(new Integer(snacFamilyInfo.getFamily()), snacFamilyInfo);
        }
    }
}

